/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.requisition;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Transient;
import javax.xml.bind.ValidationException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.provision.persist.OnmsNodeRequisition;
import org.opennms.netmgt.provision.persist.RequisitionVisitor;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="model-import")
@ValidateUsing(value="model-import.xsd")
public class Requisition
implements Serializable,
Comparable<Requisition> {
    private static final Logger LOG = LoggerFactory.getLogger(Requisition.class);
    private static final long serialVersionUID = 1629774241824443273L;
    @XmlTransient
    private Map<String, OnmsNodeRequisition> m_nodeReqs = new LinkedHashMap<String, OnmsNodeRequisition>();
    @XmlElement(name="node")
    protected List<RequisitionNode> m_nodes = new ArrayList<RequisitionNode>();
    @XmlAttribute(name="date-stamp")
    protected XMLGregorianCalendar m_dateStamp;
    @XmlAttribute(name="foreign-source")
    protected String m_foreignSource = "imported:";
    @XmlAttribute(name="last-import")
    protected XMLGregorianCalendar m_lastImport;
    @XmlTransient
    private Resource m_resource;

    public RequisitionNode getNode(String foreignId) {
        if (this.m_nodes != null) {
            for (RequisitionNode n : this.m_nodes) {
                if (!n.getForeignId().equals(foreignId)) continue;
                LOG.debug("returning node '{}' for foreign id '{}'", (Object)n, (Object)foreignId);
                return n;
            }
        }
        return null;
    }

    public void deleteNode(RequisitionNode node) {
        if (this.m_nodes != null) {
            Iterator<RequisitionNode> i = this.m_nodes.iterator();
            while (i.hasNext()) {
                RequisitionNode n = i.next();
                if (!n.getForeignId().equals(node.getForeignId())) continue;
                i.remove();
                break;
            }
        }
    }

    public void deleteNode(String foreignId) {
        if (this.m_nodes != null) {
            Iterator<RequisitionNode> i = this.m_nodes.iterator();
            while (i.hasNext()) {
                RequisitionNode n = i.next();
                if (!n.getForeignId().equals(foreignId)) continue;
                i.remove();
                break;
            }
        }
    }

    @XmlTransient
    public RequisitionNode[] getNode() {
        return this.getNodes().toArray(new RequisitionNode[0]);
    }

    public List<RequisitionNode> getNodes() {
        return this.m_nodes;
    }

    public void setNodes(List<RequisitionNode> nodes) {
        this.m_nodes = nodes;
        this.updateNodeCache();
    }

    public void insertNode(RequisitionNode node) {
        this.updateNodeCacheIfNecessary();
        if (this.m_nodeReqs.containsKey(node.getForeignId())) {
            RequisitionNode n = this.m_nodeReqs.get(node.getForeignId()).getNode();
            this.m_nodes.remove(n);
        }
        this.m_nodes.add(0, node);
        this.m_nodeReqs.put(node.getForeignId(), new OnmsNodeRequisition(this.getForeignSource(), node));
    }

    public void putNode(RequisitionNode node) {
        this.updateNodeCacheIfNecessary();
        if (this.m_nodeReqs.containsKey(node.getForeignId())) {
            RequisitionNode n = this.m_nodeReqs.get(node.getForeignId()).getNode();
            this.m_nodes.remove(n);
        }
        this.m_nodes.add(node);
        this.m_nodeReqs.put(node.getForeignId(), new OnmsNodeRequisition(this.getForeignSource(), node));
    }

    public XMLGregorianCalendar getDateStamp() {
        return this.m_dateStamp;
    }

    public void setDateStamp(XMLGregorianCalendar value) {
        this.m_dateStamp = value;
    }

    public void updateDateStamp() {
        try {
            this.m_dateStamp = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
        }
        catch (DatatypeConfigurationException e) {
            LOG.warn("unable to update datestamp", (Throwable)e);
        }
    }

    public String getForeignSource() {
        if (this.m_foreignSource == null) {
            return "imported:";
        }
        return this.m_foreignSource;
    }

    public void setForeignSource(String value) {
        this.m_foreignSource = value;
    }

    public XMLGregorianCalendar getLastImport() {
        return this.m_lastImport;
    }

    @Transient
    @XmlTransient
    public Date getLastImportAsDate() {
        return this.m_lastImport == null ? null : this.m_lastImport.toGregorianCalendar().getTime();
    }

    public void setLastImport(XMLGregorianCalendar value) {
        this.m_lastImport = value;
    }

    public void updateLastImported() {
        try {
            this.m_lastImport = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
        }
        catch (DatatypeConfigurationException e) {
            LOG.warn("unable to update last import datestamp", (Throwable)e);
        }
    }

    public Requisition() {
        this.updateNodeCache();
        this.updateDateStamp();
    }

    public Requisition(String foreignSource) {
        this();
        this.m_foreignSource = foreignSource;
    }

    public Resource getResource() {
        return this.m_resource;
    }

    public void setResource(Resource resource) {
        this.m_resource = resource;
    }

    private void updateNodeCache() {
        this.m_nodeReqs.clear();
        if (this.m_nodes != null) {
            for (RequisitionNode n : this.m_nodes) {
                this.m_nodeReqs.put(n.getForeignId(), new OnmsNodeRequisition(this.getForeignSource(), n));
            }
        }
    }

    private void updateNodeCacheIfNecessary() {
        if (this.m_nodes != null && this.m_nodeReqs.size() != this.m_nodes.size()) {
            this.updateNodeCache();
        }
    }

    public void visit(RequisitionVisitor visitor) {
        this.updateNodeCacheIfNecessary();
        if (visitor == null) {
            LOG.warn("no visitor specified!");
            return;
        }
        visitor.visitModelImport(this);
        for (OnmsNodeRequisition nodeReq : this.m_nodeReqs.values()) {
            nodeReq.visit(visitor);
        }
        visitor.completeModelImport(this);
    }

    public OnmsNodeRequisition getNodeRequistion(String foreignId) {
        this.updateNodeCacheIfNecessary();
        return this.m_nodeReqs.get(foreignId);
    }

    @XmlTransient
    public int getNodeCount() {
        return this.m_nodes == null ? 0 : this.m_nodes.size();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_dateStamp == null ? 0 : this.m_dateStamp.hashCode());
        result = 31 * result + (this.m_foreignSource == null ? 0 : this.m_foreignSource.hashCode());
        result = 31 * result + (this.m_lastImport == null ? 0 : this.m_lastImport.hashCode());
        result = 31 * result + (this.m_nodes == null ? 0 : this.m_nodes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Requisition)) {
            return false;
        }
        Requisition other = (Requisition)obj;
        if (this.m_dateStamp == null ? other.m_dateStamp != null : !this.m_dateStamp.equals(other.m_dateStamp)) {
            return false;
        }
        if (this.m_foreignSource == null ? other.m_foreignSource != null : !this.m_foreignSource.equals(other.m_foreignSource)) {
            return false;
        }
        if (this.m_lastImport == null ? other.m_lastImport != null : !this.m_lastImport.equals(other.m_lastImport)) {
            return false;
        }
        return !(this.m_nodes == null ? other.m_nodes != null : !this.m_nodes.equals(other.m_nodes));
    }

    public String toString() {
        return "Requisition [nodes=" + this.m_nodes + ", dateStamp=" + this.m_dateStamp + ", foreignSource=" + this.m_foreignSource + ", lastImport=" + this.m_lastImport + "]";
    }

    @Override
    public int compareTo(Requisition obj) {
        return new CompareToBuilder().append((Object)this.m_foreignSource, (Object)obj.m_foreignSource).append((Object)this.m_dateStamp, (Object)obj.m_dateStamp).append((Object)this.m_lastImport, (Object)obj.m_lastImport).toComparison();
    }

    public void validate() throws ValidationException {
        Integer count;
        String foreignId;
        HashMap<String, Integer> foreignSourceCounts = new HashMap<String, Integer>();
        HashSet<CallSite> errors = new HashSet<CallSite>();
        if (this.m_foreignSource == null) {
            throw new ValidationException("Requisition 'foreign-source' must be set!");
        }
        if (this.m_foreignSource.contains("/")) {
            throw new ValidationException("Foreign Source (" + this.m_foreignSource + ") contains invalid characters. ('/' is forbidden.)");
        }
        for (RequisitionNode requisitionNode : new ArrayList<RequisitionNode>(this.m_nodes)) {
            int n;
            foreignId = requisitionNode.getForeignId();
            requisitionNode.validate();
            count = (Integer)foreignSourceCounts.get(foreignId);
            if (count == null) {
                n = 1;
            } else {
                count = count + 1;
                n = count;
            }
            foreignSourceCounts.put(foreignId, n);
        }
        for (Map.Entry entry : foreignSourceCounts.entrySet()) {
            foreignId = (String)entry.getKey();
            count = (Integer)entry.getValue();
            if (count <= 1) continue;
            errors.add((CallSite)((Object)(foreignId + " (" + count + " found)")));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Duplicate nodes found on foreign source ").append(this.getForeignSource()).append(": ");
            Iterator iterator = errors.iterator();
            while (iterator.hasNext()) {
                String error = (String)iterator.next();
                sb.append(error);
                if (!iterator.hasNext()) continue;
                sb.append(", ");
            }
            throw new ValidationException(sb.toString());
        }
    }

    @XmlTransient
    @Transient
    public Date getDate() {
        return this.getDateStamp() == null ? null : this.getDateStamp().toGregorianCalendar().getTime();
    }

    public void setDate(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        try {
            this.setDateStamp(DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar));
        }
        catch (DatatypeConfigurationException e) {
            LOG.warn("Failed to turn {} into an XML date.", (Object)date);
        }
    }
}

