/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LocaleUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LocaleUtils.class);
    private static final Locale DEFAULT_LOCALE = new Locale(Locale.ENGLISH.getLanguage(), Locale.US.getCountry());

    public static Locale parseLocale(String string) {
        String[] segments = string.split("[-_]");
        if (segments.length == 1) {
            if ("".equals(segments[0].trim())) {
                throw new IllegalArgumentException("Invalid locale string: " + string);
            }
            return new Locale(segments[0].trim());
        }
        if (segments.length == 2) {
            if ("".equals(segments[0].trim()) || "".equals(segments[1].trim())) {
                throw new IllegalArgumentException("Invalid locale string: " + string);
            }
            return new Locale(segments[0].trim(), segments[1].trim());
        }
        if (segments.length == 3) {
            if ("".equals(segments[0].trim()) || "".equals(segments[1].trim()) || "".equals(segments[2].trim())) {
                throw new IllegalArgumentException("Invalid locale string: " + string);
            }
            return new Locale(segments[0].trim(), segments[1].trim(), segments[2].trim());
        }
        throw new IllegalArgumentException("Invalid locale string: " + string);
    }

    public static Locale bestLocale(Locale[] preferredLocales, Locale[] availableLocales) {
        boolean hasCountry = false;
        boolean hasVariant = false;
        for (Locale prefer : preferredLocales) {
            if (prefer != null) {
                if (prefer.getVariant() != null && !"".equals(prefer.getVariant())) {
                    hasVariant = true;
                }
                if (prefer.getCountry() != null && !"".equals(prefer.getCountry())) {
                    hasCountry = true;
                }
                for (Locale avail : availableLocales) {
                    if (avail != null) {
                        if (avail.getVariant() != null && !"".equals(avail.getVariant())) {
                            hasVariant = true;
                        }
                        if (avail.getCountry() != null && !"".equals(avail.getCountry())) {
                            hasCountry = true;
                        }
                        if (!prefer.equals(avail)) continue;
                        return avail;
                    }
                    LOG.trace("Null locale in available list");
                }
                continue;
            }
            LOG.trace("Null locale in preferred list");
        }
        if (hasVariant) {
            for (Locale prefer : preferredLocales) {
                if (prefer != null) {
                    for (Locale avail : availableLocales) {
                        if (avail != null) {
                            if (!prefer.getLanguage().equalsIgnoreCase(avail.getLanguage()) || prefer.getCountry() != null && !prefer.getCountry().equalsIgnoreCase(avail.getCountry())) continue;
                            return avail;
                        }
                        LOG.trace("Null locale in available list");
                    }
                    continue;
                }
                LOG.trace("Null locale in preferred list");
            }
        }
        if (hasCountry) {
            for (Locale prefer : preferredLocales) {
                if (prefer != null) {
                    for (Locale avail : availableLocales) {
                        if (avail != null) {
                            if (!prefer.getLanguage().equalsIgnoreCase(avail.getLanguage())) continue;
                            return avail;
                        }
                        LOG.trace("Null locale in available list");
                    }
                    continue;
                }
                LOG.trace("Null locale in preferred list");
            }
        }
        return DEFAULT_LOCALE;
    }
}

