/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.config.requisition.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.config.requisition.RequisitionAsset;

public final class ImmutableRequisitionAsset
implements RequisitionAsset {
    private final String name;
    private final String value;

    private ImmutableRequisitionAsset(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static ImmutableRequisitionAsset newInstance(String name, String value) {
        return new ImmutableRequisitionAsset(Objects.requireNonNull(name, "name is required"), value);
    }

    public static RequisitionAsset immutableCopy(RequisitionAsset requisitionAsset) {
        if (requisitionAsset == null || requisitionAsset instanceof ImmutableRequisitionAsset) {
            return requisitionAsset;
        }
        return ImmutableRequisitionAsset.newInstance(requisitionAsset.getName(), requisitionAsset.getValue());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(RequisitionAsset requisitionAsset) {
        return new Builder(requisitionAsset);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableRequisitionAsset that = (ImmutableRequisitionAsset)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public String toString() {
        return "ImmutableRequisitionAsset{name='" + this.name + "', value='" + this.value + "'}";
    }

    public static final class Builder {
        private String name;
        private String value;

        private Builder() {
        }

        private Builder(RequisitionAsset requisitionAsset) {
            this.name = requisitionAsset.getName();
            this.value = requisitionAsset.getValue();
        }

        public Builder setName(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        public Builder setValue(String value) {
            this.value = value;
            return this;
        }

        public ImmutableRequisitionAsset build() {
            return ImmutableRequisitionAsset.newInstance(this.name, this.value);
        }
    }
}

