/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.graph.status.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.graph.status.StatusInfo;
import org.opennms.integration.api.v1.model.Severity;

public final class StatusInfoImmutable
implements StatusInfo {
    private final Severity severity;
    private final long count;

    public StatusInfoImmutable(Builder builder) {
        this.severity = Objects.requireNonNull(builder.severity, "severity cannot be null.");
        this.count = builder.count;
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder newBuilder(Severity severity) {
        Objects.requireNonNull(severity);
        return new Builder().severity(severity).count(0L);
    }

    public static Builder newBuilderFrom(StatusInfo status) {
        return new Builder().severity(status.getSeverity()).count(status.getCount());
    }

    public static StatusInfo immutableCopy(StatusInfo statusInfo) {
        if (statusInfo == null || statusInfo instanceof StatusInfo) {
            return statusInfo;
        }
        return StatusInfoImmutable.newBuilderFrom(statusInfo).build();
    }

    public static final class Builder {
        private Severity severity;
        private long count;

        private Builder() {
        }

        public Builder severity(Severity severity) {
            this.severity = Objects.requireNonNull(severity);
            return this;
        }

        public Builder count(long count) {
            if (count < 0L) {
                throw new IllegalArgumentException("Count must be >= 0");
            }
            this.count = count;
            return this;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public long getCount() {
            return this.count;
        }

        public StatusInfo build() {
            return new StatusInfoImmutable(this);
        }
    }
}

