/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.model.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.model.AlarmFeedback;

public final class ImmutableAlarmFeedback
implements AlarmFeedback {
    private final String situationKey;
    private final String situationFingerprint;
    private final String alarmKey;
    private final AlarmFeedback.Type feedbackType;
    private final String reason;
    private final String user;
    private final long timestamp;

    private ImmutableAlarmFeedback(Builder builder) {
        this.situationKey = builder.situationKey;
        this.situationFingerprint = builder.situationFingerprint;
        this.alarmKey = builder.alarmKey;
        this.feedbackType = builder.feedbackType;
        this.reason = builder.reason;
        this.user = builder.user;
        this.timestamp = builder.timestamp;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(AlarmFeedback alarmFeedback) {
        return new Builder(alarmFeedback);
    }

    public static AlarmFeedback immutableCopy(AlarmFeedback alarmFeedback) {
        if (alarmFeedback == null || alarmFeedback instanceof ImmutableAlarmFeedback) {
            return alarmFeedback;
        }
        return ImmutableAlarmFeedback.newBuilderFrom(alarmFeedback).build();
    }

    @Override
    public String getSituationKey() {
        return this.situationKey;
    }

    @Override
    public String getSituationFingerprint() {
        return this.situationFingerprint;
    }

    @Override
    public String getAlarmKey() {
        return this.alarmKey;
    }

    @Override
    public AlarmFeedback.Type getFeedbackType() {
        return this.feedbackType;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableAlarmFeedback that = (ImmutableAlarmFeedback)o;
        return this.timestamp == that.timestamp && Objects.equals(this.situationKey, that.situationKey) && Objects.equals(this.situationFingerprint, that.situationFingerprint) && Objects.equals(this.alarmKey, that.alarmKey) && this.feedbackType == that.feedbackType && Objects.equals(this.reason, that.reason) && Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.situationKey, this.situationFingerprint, this.alarmKey, this.feedbackType, this.reason, this.user, this.timestamp});
    }

    public String toString() {
        return "ImmutableAlarmFeedback{situationKey='" + this.situationKey + "', situationFingerprint='" + this.situationFingerprint + "', alarmKey='" + this.alarmKey + "', feedbackType=" + this.feedbackType + ", reason='" + this.reason + "', user='" + this.user + "', timestamp=" + this.timestamp + "}";
    }

    public static final class Builder {
        private String situationKey;
        private String situationFingerprint;
        private String alarmKey;
        private AlarmFeedback.Type feedbackType;
        private String reason;
        private String user;
        private Long timestamp;

        private Builder() {
        }

        private Builder(AlarmFeedback alarmFeedback) {
        }

        public Builder setSituationKey(String situationKey) {
            this.situationKey = Objects.requireNonNull(situationKey);
            return this;
        }

        public Builder setSituationFingerprint(String situationFingerprint) {
            this.situationFingerprint = situationFingerprint;
            return this;
        }

        public Builder setAlarmKey(String alarmKey) {
            this.alarmKey = Objects.requireNonNull(alarmKey);
            return this;
        }

        public Builder setFeedbackType(AlarmFeedback.Type feedbackType) {
            this.feedbackType = Objects.requireNonNull(feedbackType);
            return this;
        }

        public Builder setReason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public ImmutableAlarmFeedback build() {
            Objects.requireNonNull(this.situationKey, "The situation key cannot be null");
            Objects.requireNonNull(this.alarmKey, "The alarm key cannot be null");
            Objects.requireNonNull(this.feedbackType, "The feedback type cannot be null");
            Objects.requireNonNull(this.timestamp, "The timestamp cannot be null");
            return new ImmutableAlarmFeedback(this);
        }
    }
}

