/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.srv.tsaas.shell;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opennms.plugins.cloud.srv.tsaas.TsaasStorage;
import org.opennms.plugins.cloud.srv.tsaas.shell.MetricWrite;

public class MetricWriteTest {
    @Test
    public void shouldWrite() throws Exception {
        TsaasStorage tss = (TsaasStorage)Mockito.mock(TsaasStorage.class);
        MetricWrite write = new MetricWrite();
        write.tss = tss;
        write.count = 3;
        write.execute();
        ((TsaasStorage)Mockito.verify((Object)tss, (VerificationMode)Mockito.times((int)1))).store((List)ArgumentMatchers.any());
    }

    @Test
    public void shouldRejectNegativeCount() throws Exception {
        MetricWrite write = new MetricWrite();
        write.count = -1;
        Assert.assertThrows(IllegalArgumentException.class, write::execute);
    }

    @Test
    public void shouldRejectZeroCount() throws Exception {
        MetricWrite write = new MetricWrite();
        write.count = 0;
        Assert.assertThrows(IllegalArgumentException.class, write::execute);
    }
}

