/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.testserver;

import io.grpc.Server;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.awaitility.Awaitility;
import org.opennms.integration.api.v1.timeseries.TimeSeriesStorage;
import org.opennms.plugins.cloud.grpc.GrpcConnectionConfig;
import org.opennms.plugins.cloud.srv.tsaas.grpc.comp.ZstdCodecRegisterUtil;
import org.opennms.plugins.cloud.testserver.ConfigGrpcImpl;
import org.opennms.plugins.cloud.testserver.GrpcTestServerInterceptor;
import org.opennms.plugins.cloud.testserver.TsaasGrpcImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcTestServer {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcTestServer.class);
    private GrpcConnectionConfig config;
    private Server server;
    private final TsaasGrpcImpl timeSeriesService;
    private final ConfigGrpcImpl configGrpcService = new ConfigGrpcImpl();

    public GrpcTestServer(GrpcConnectionConfig config, TimeSeriesStorage storage) {
        this.timeSeriesService = new TsaasGrpcImpl(storage);
        this.config = config;
    }

    @PostConstruct
    public void startServer(String certPrefix, String keyCertChainFilename, String keyFilename) throws IOException {
        NettyServerBuilder builder = (NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forPort(this.config.getPort()).addService(this.configGrpcService)).addService(this.timeSeriesService)).decompressorRegistry(ZstdCodecRegisterUtil.createDecompressorRegistry())).compressorRegistry(ZstdCodecRegisterUtil.createCompressorRegistry())).intercept(new GrpcTestServerInterceptor());
        if (GrpcConnectionConfig.Security.TLS == this.config.getSecurity() || GrpcConnectionConfig.Security.MTLS == this.config.getSecurity()) {
            builder.sslContext(GrpcSslContexts.forServer(this.getClass().getResourceAsStream(certPrefix + "/" + keyCertChainFilename), this.getClass().getResourceAsStream(certPrefix + "/" + keyFilename)).trustManager(this.getClass().getResourceAsStream(certPrefix + "/servertruststore.pem")).build());
        }
        this.server = builder.build().start();
        LOG.info("Grpc Server started, listening on {}", (Object)this.server.getPort());
        if (this.server.getPort() != this.config.getPort()) {
            LOG.info("saving port {} into config", (Object)this.server.getPort());
            this.config = this.config.toBuilder().port(this.server.getPort()).build();
        }
        this.configGrpcService.init(this.config);
        CompletableFuture.runAsync(() -> {
            try {
                this.server.awaitTermination();
                this.timeSeriesService.shutdown();
            }
            catch (InterruptedException ex) {
                LOG.error(ex.getMessage(), ex);
            }
        });
    }

    @PreDestroy
    public void stopServer() {
        if (this.server != null) {
            this.server.shutdown();
            Awaitility.await().until(() -> this.server.isShutdown());
        }
        LOG.info("Grpc Server stopped");
    }

    public GrpcConnectionConfig getConfig() {
        return this.config;
    }
}

