/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.jline;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.apache.felix.service.command.Process;
import org.jline.builtins.Options;

public class Procedural {
    static final String[] functions = new String[]{"each", "if", "not", "throw", "try", "until", "while", "break", "continue"};

    public Object _main(CommandSession session, Object[] argv) throws Throwable {
        if (argv == null || argv.length < 1) {
            throw new IllegalArgumentException();
        }
        Process process = Process.Utils.current();
        try {
            return this.run(session, process, argv);
        }
        catch (OptionException e) {
            process.err().println(e.getMessage());
            process.error(2);
        }
        catch (HelpException e) {
            process.err().println(e.getMessage());
            process.error(0);
        }
        catch (ThrownException e) {
            process.error(1);
            throw e.getCause();
        }
        return null;
    }

    protected Options parseOptions(CommandSession session, String[] usage, Object[] argv) throws HelpException, OptionException {
        try {
            Options opt = Options.compile(usage, s -> this.get(session, (String)s)).parse(argv, true);
            if (opt.isSet("help")) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                opt.usage(new PrintStream(baos));
                throw new HelpException(baos.toString());
            }
            return opt;
        }
        catch (IllegalArgumentException e) {
            throw new OptionException(e.getMessage(), e);
        }
    }

    protected String get(CommandSession session, String name) {
        Object o = session.get(name);
        return o != null ? o.toString() : null;
    }

    protected Object run(CommandSession session, Process process, Object[] argv) throws Throwable {
        switch (argv[0].toString()) {
            case "each": {
                return this.doEach(session, process, argv);
            }
            case "if": {
                return this.doIf(session, process, argv);
            }
            case "not": {
                return this.doNot(session, process, argv);
            }
            case "throw": {
                return this.doThrow(session, process, argv);
            }
            case "try": {
                return this.doTry(session, process, argv);
            }
            case "until": {
                return this.doUntil(session, process, argv);
            }
            case "while": {
                return this.doWhile(session, process, argv);
            }
            case "break": {
                return this.doBreak(session, process, argv);
            }
            case "continue": {
                return this.doContinue(session, process, argv);
            }
        }
        throw new UnsupportedOperationException();
    }

    protected List<Object> doEach(CommandSession session, Process process, Object[] argv) throws Exception {
        String[] usage = new String[]{"each -  loop over the elements", "Usage: each [-r] elements [do] { closure }", "         elements              an array to iterate on", "         closure               a closure to call", "  -? --help                    Show help", "  -r --result                  Return a list containing each iteration result"};
        Options opt = this.parseOptions(session, usage, argv);
        Collection<Object> elements = this.getElements(opt);
        if (opt.argObjects().size() > 0 && "do".equals(opt.argObjects().get(0))) {
            opt.argObjects().remove(0);
        }
        List<Function> functions = this.getFunctions(opt);
        if (elements == null || functions == null || functions.size() != 1) {
            process.err().println("usage: each elements [do] { closure }");
            process.err().println("       elements: an array to iterate on");
            process.err().println("       closure: a function or closure to call");
            process.error(2);
            return null;
        }
        ArrayList<Object> args = new ArrayList<Object>();
        ArrayList<Object> results = new ArrayList<Object>();
        args.add(null);
        for (Object x : elements) {
            this.checkInterrupt();
            args.set(0, x);
            try {
                results.add(functions.get(0).execute(session, args));
            }
            catch (BreakException b) {
                break;
            }
            catch (ContinueException continueException) {
            }
        }
        return opt.isSet("result") ? results : null;
    }

    protected Object doIf(CommandSession session, Process process, Object[] argv) throws Exception {
        String[] usage = new String[]{"if -  if / then / else construct", "Usage: if {condition} [then] {if-action} [elif {cond} [then] {elif-action}]... [else] {else-action}", "  -? --help                    Show help"};
        Options opt = this.parseOptions(session, usage, argv);
        ArrayList<Function> conditions = new ArrayList<Function>();
        ArrayList<Function> actions = new ArrayList<Function>();
        Function elseFunction = null;
        int step = 0;
        boolean error = false;
        for (Object obj : opt.argObjects()) {
            switch (step) {
                case 0: {
                    if (obj instanceof Function) {
                        conditions.add((Function)obj);
                    } else {
                        error = true;
                    }
                    step = 1;
                    break;
                }
                case 1: {
                    if ("then".equals(obj)) {
                        step = 2;
                        break;
                    }
                }
                case 2: {
                    if (obj instanceof Function) {
                        actions.add((Function)obj);
                        step = 3;
                        break;
                    }
                    error = true;
                    break;
                }
                case 3: {
                    if ("elif".equals(obj)) {
                        step = 4;
                        break;
                    }
                    if ("else".equals(obj)) {
                        step = 7;
                        break;
                    }
                    if (obj instanceof Function) {
                        elseFunction = (Function)obj;
                        step = 8;
                        break;
                    }
                    error = true;
                    break;
                }
                case 4: {
                    if (obj instanceof Function) {
                        conditions.add((Function)obj);
                    } else {
                        error = true;
                    }
                    step = 5;
                    break;
                }
                case 5: {
                    if ("then".equals(obj)) {
                        step = 6;
                        break;
                    }
                }
                case 6: {
                    if (obj instanceof Function) {
                        actions.add((Function)obj);
                        step = 3;
                        break;
                    }
                    error = true;
                    break;
                }
                case 7: {
                    if (obj instanceof Function) {
                        elseFunction = (Function)obj;
                        step = 8;
                        break;
                    }
                    error = true;
                    break;
                }
                case 8: {
                    error = true;
                }
            }
            if (!error) continue;
            break;
        }
        error |= conditions.isEmpty();
        if (error |= conditions.size() != actions.size()) {
            process.err().println("usage: if {condition} [then] {if-action} [elif {elif-action}]... [else] {else-action}");
            process.error(2);
            return null;
        }
        int length = conditions.size();
        for (int i = 0; i < length; ++i) {
            if (!this.isTrue(session, (Function)conditions.get(i))) continue;
            return ((Function)actions.get(i)).execute(session, null);
        }
        if (elseFunction != null) {
            return elseFunction.execute(session, null);
        }
        return null;
    }

    protected Boolean doNot(CommandSession session, Process process, Object[] argv) throws Exception {
        String[] usage = new String[]{"not -  return the opposite condition", "Usage: not { condition }", "  -? --help                    Show help"};
        Options opt = this.parseOptions(session, usage, argv);
        List<Function> functions = this.getFunctions(opt);
        if (functions == null || functions.size() != 1) {
            process.err().println("usage: not { condition }");
            process.error(2);
            return null;
        }
        return !this.isTrue(session, functions.get(0));
    }

    protected Object doThrow(CommandSession session, Process process, Object[] argv) throws ThrownException, HelpException, OptionException {
        String[] usage = new String[]{"throw -  throw an exception", "Usage: throw [ message [ cause ] ]", "       throw exception", "       throw", "  -? --help                    Show help"};
        Options opt = this.parseOptions(session, usage, argv);
        if (opt.argObjects().size() == 0) {
            Object exception = session.get("exception");
            if (exception instanceof Throwable) {
                throw new ThrownException((Throwable)exception);
            }
            throw new ThrownException(new Exception());
        }
        if (opt.argObjects().size() == 1 && opt.argObjects().get(0) instanceof Throwable) {
            throw new ThrownException((Throwable)opt.argObjects().get(0));
        }
        String message = opt.argObjects().get(0).toString();
        Throwable cause = null;
        if (opt.argObjects().size() > 1 && opt.argObjects().get(1) instanceof Throwable) {
            cause = (Throwable)opt.argObjects().get(1);
        }
        throw new ThrownException(new Exception(message, cause));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doTry(CommandSession session, Process process, Object[] argv) throws Exception {
        String[] usage = new String[]{"try -  try / catch / finally construct", "Usage: try { try-action } [ [catch] { catch-action } [ [finally] { finally-action } ]  ]", "  -? --help                    Show help"};
        Options opt = this.parseOptions(session, usage, argv);
        Function tryAction = null;
        Function catchFunction = null;
        Function finallyFunction = null;
        int step = 0;
        boolean error = false;
        for (Object obj : opt.argObjects()) {
            if (tryAction == null) {
                if (!(obj instanceof Function)) {
                    error = true;
                    break;
                }
                tryAction = (Function)obj;
                step = 1;
                continue;
            }
            if ("catch".equals(obj)) {
                if (step != 1) {
                    error = true;
                    break;
                }
                step = 2;
                continue;
            }
            if ("finally".equals(obj)) {
                if (step != 1 && step != 3) {
                    error = true;
                    break;
                }
                step = 4;
                continue;
            }
            if (step == 1 || step == 2) {
                if (!(obj instanceof Function)) {
                    error = true;
                    break;
                }
                catchFunction = (Function)obj;
                step = 3;
                continue;
            }
            if (step == 3 || step == 4) {
                if (!(obj instanceof Function)) {
                    error = true;
                    break;
                }
                finallyFunction = (Function)obj;
                step = 5;
                continue;
            }
            error = true;
            break;
        }
        error |= tryAction == null;
        if (error |= catchFunction == null && finallyFunction == null) {
            process.err().println("usage: try { try-action } [ [catch] { catch-action } [ [finally] { finally-action } ] ]");
            process.error(2);
            return null;
        }
        try {
            Object object = tryAction.execute(session, null);
            return object;
        }
        catch (BreakException b) {
            throw b;
        }
        catch (Exception e) {
            session.put("exception", e);
            if (catchFunction != null) {
                catchFunction.execute(session, null);
            }
            Object var12_14 = null;
            return var12_14;
        }
        finally {
            if (finallyFunction != null) {
                finallyFunction.execute(session, null);
            }
        }
    }

    protected Object doWhile(CommandSession session, Process process, Object[] argv) throws Exception {
        String[] usage = new String[]{"while -  while loop", "Usage: while { condition } [do] { action }", "  -? --help                    Show help"};
        Options opt = this.parseOptions(session, usage, argv);
        Function condition = null;
        Function action = null;
        int step = 0;
        boolean error = false;
        for (Object obj : opt.argObjects()) {
            if (condition == null) {
                if (!(obj instanceof Function)) {
                    error = true;
                    break;
                }
                condition = (Function)obj;
                step = 1;
                continue;
            }
            if ("do".equals(obj)) {
                if (step != 1) {
                    error = true;
                    break;
                }
                step = 2;
                continue;
            }
            if (step == 1 || step == 2) {
                if (!(obj instanceof Function)) {
                    error = true;
                    break;
                }
                action = (Function)obj;
                step = 3;
                continue;
            }
            error = true;
            break;
        }
        error |= condition == null;
        if (error |= action == null) {
            process.err().println("usage: while { condition } [do] { action }");
            process.error(2);
            return null;
        }
        while (this.isTrue(session, condition)) {
            try {
                action.execute(session, null);
            }
            catch (BreakException b) {
                break;
            }
            catch (ContinueException continueException) {
            }
        }
        return null;
    }

    protected Object doUntil(CommandSession session, Process process, Object[] argv) throws Exception {
        String[] usage = new String[]{"until -  until loop", "Usage: until { condition } [do] { action }", "  -? --help                    Show help"};
        Options opt = this.parseOptions(session, usage, argv);
        Function condition = null;
        Function action = null;
        int step = 0;
        boolean error = false;
        for (Object obj : opt.argObjects()) {
            if (condition == null) {
                if (!(obj instanceof Function)) {
                    error = true;
                    break;
                }
                condition = (Function)obj;
                step = 1;
                continue;
            }
            if ("do".equals(obj)) {
                if (step != 1) {
                    error = true;
                    break;
                }
                step = 2;
                continue;
            }
            if (step == 1 || step == 2) {
                if (!(obj instanceof Function)) {
                    error = true;
                    break;
                }
                action = (Function)obj;
                step = 3;
                continue;
            }
            error = true;
            break;
        }
        error |= condition == null;
        if (error |= action == null) {
            process.err().println("usage: until { condition } [do] { action }");
            process.error(2);
            return null;
        }
        while (!this.isTrue(session, condition)) {
            try {
                action.execute(session, null);
            }
            catch (BreakException e) {
                break;
            }
            catch (ContinueException continueException) {
            }
        }
        return null;
    }

    protected Object doBreak(CommandSession session, Process process, Object[] argv) throws Exception {
        String[] usage = new String[]{"break -  break from loop", "Usage: break", "  -? --help                    Show help"};
        this.parseOptions(session, usage, argv);
        throw new BreakException();
    }

    protected Object doContinue(CommandSession session, Process process, Object[] argv) throws Exception {
        String[] usage = new String[]{"continue -  continue loop", "Usage: continue", "  -? --help                    Show help"};
        this.parseOptions(session, usage, argv);
        throw new ContinueException();
    }

    private boolean isTrue(CommandSession session, Function function) throws Exception {
        this.checkInterrupt();
        return this.isTrue(function.execute(session, null));
    }

    private boolean isTrue(Object result) throws InterruptedException {
        this.checkInterrupt();
        if (result == null) {
            return false;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result instanceof Number && 0 == ((Number)result).intValue()) {
            return false;
        }
        if ("".equals(result)) {
            return false;
        }
        return !"0".equals(result);
    }

    private void checkInterrupt() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("interrupted");
        }
    }

    private Collection<Object> getElements(Options opt) {
        List<Object> elements = null;
        if (opt.argObjects().size() > 0) {
            Object o = opt.argObjects().remove(0);
            if (o instanceof Collection) {
                elements = (List<Object>)o;
            } else if (o != null && o.getClass().isArray()) {
                elements = Arrays.asList((Object[])o);
            }
        }
        return elements;
    }

    private List<Function> getFunctions(Options opt) {
        ArrayList<Function> functions = new ArrayList<Function>();
        for (Object o : opt.argObjects()) {
            if (o instanceof Function) {
                functions.add((Function)o);
                continue;
            }
            functions = null;
            break;
        }
        return functions;
    }

    protected static class ContinueException
    extends Exception {
        protected ContinueException() {
        }
    }

    protected static class BreakException
    extends Exception {
        protected BreakException() {
        }
    }

    protected static class ThrownException
    extends Exception {
        public ThrownException(Throwable cause) {
            super(cause);
        }
    }

    protected static class HelpException
    extends Exception {
        public HelpException(String message) {
            super(message);
        }
    }

    protected static class OptionException
    extends Exception {
        public OptionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

