/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.graph.immutables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.graph.Graph;
import org.opennms.integration.api.v1.graph.GraphContainer;
import org.opennms.integration.api.v1.graph.GraphContainerInfo;
import org.opennms.integration.api.v1.graph.GraphInfo;
import org.opennms.integration.api.v1.graph.immutables.ImmutableGraph;
import org.opennms.integration.api.v1.graph.immutables.ImmutableGraphInfo;

public final class ImmutableGraphContainer
implements GraphContainer {
    private final List<Graph> graphs;
    private final Map<String, Object> properties;

    private ImmutableGraphContainer(Builder builder) {
        this.properties = Collections.unmodifiableMap(builder.properties);
        this.graphs = Collections.unmodifiableList(builder.graphs.values().stream().map(ImmutableGraph::immutableCopy).sorted(Comparator.comparing(GraphInfo::getNamespace)).collect(Collectors.toList()));
    }

    @Override
    public List<Graph> getGraphs() {
        return new ArrayList<Graph>(this.graphs);
    }

    @Override
    public Graph getGraph(String namespace) {
        return this.graphs.stream().filter(g -> g.getNamespace().equals(namespace)).findAny().orElse(null);
    }

    @Override
    public String getId() {
        return (String)this.properties.get("id");
    }

    @Override
    public String getDescription() {
        return (String)this.properties.get("description");
    }

    public void setDescription(String description) {
        this.properties.put("description", description);
    }

    @Override
    public String getLabel() {
        return (String)this.properties.get("label");
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public <T> T getProperty(String key) {
        return (T)this.properties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableGraphContainer that = (ImmutableGraphContainer)o;
        return Objects.equals(this.graphs, that.graphs) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.graphs, this.properties);
    }

    public String toString() {
        return "ImmutableGraphContainer{graphs=" + this.graphs + ", properties=" + this.properties + "}";
    }

    public static Builder newBuilder(GraphContainerInfo containerInfo) {
        Objects.requireNonNull(containerInfo);
        return new Builder().containerInfo(containerInfo);
    }

    public static Builder newBuilderFrom(GraphContainer fromGraphContainer) {
        Objects.requireNonNull(fromGraphContainer);
        return new Builder().graphContainer(fromGraphContainer);
    }

    public static GraphContainer immutableCopy(GraphContainer graphContainer) {
        if (graphContainer == null || graphContainer instanceof ImmutableGraphContainer) {
            return graphContainer;
        }
        return ImmutableGraphContainer.newBuilderFrom(graphContainer).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Graph> graphs = new HashMap<String, Graph>();
        private final Map<String, Object> properties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder id(String id) {
            this.property("id", id);
            return this;
        }

        public Builder label(String label) {
            this.property("label", label);
            return this;
        }

        public Builder description(String description) {
            this.property("description", description);
            return this;
        }

        public Builder property(String name, Object value) {
            if (name == null || value == null) {
                return this;
            }
            this.properties.put(name, value);
            return this;
        }

        public Builder properties(Map<String, Object> properties) {
            Objects.requireNonNull(properties, "properties cannot be null");
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                this.property(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder containerInfo(GraphContainerInfo containerInfo) {
            this.id(containerInfo.getContainerId());
            this.label(containerInfo.getLabel());
            this.description(containerInfo.getDescription());
            return this;
        }

        public Builder graphContainer(GraphContainer fromGraphContainer) {
            Objects.requireNonNull(fromGraphContainer);
            this.properties(fromGraphContainer.getProperties());
            return this;
        }

        public Builder addGraph(Graph graph) {
            Objects.requireNonNull(graph, "Graph cannot be null");
            this.graphs.put(graph.getNamespace(), graph);
            return this;
        }

        public GraphInfo getGraphInfo(String namespace) {
            Graph graph = this.graphs.get(namespace);
            if (graph != null) {
                return ImmutableGraphInfo.newBuilder(graph.getNamespace(), graph.getLabel(), graph.getDescription()).build();
            }
            throw new NoSuchElementException("No graph with namespace '" + namespace + "' found");
        }

        public ImmutableGraphContainer build() {
            return new ImmutableGraphContainer(this);
        }
    }
}

