/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.collectors.resource.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.collectors.resource.GenericTypeResource;
import org.opennms.integration.api.v1.collectors.resource.NodeResource;
import org.opennms.integration.api.v1.collectors.resource.Resource;
import org.opennms.integration.api.v1.collectors.resource.immutables.ImmutableNodeResource;

public final class ImmutableGenericTypeResource
implements GenericTypeResource {
    private final NodeResource nodeResource;
    private final String type;
    private final String instance;

    private ImmutableGenericTypeResource(Builder builder) {
        this.nodeResource = ImmutableNodeResource.immutableCopy(builder.nodeResource);
        this.type = builder.type;
        this.instance = builder.instance;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(GenericTypeResource genericTypeResource) {
        return new Builder(genericTypeResource);
    }

    public static GenericTypeResource immutableCopy(GenericTypeResource genericTypeResource) {
        if (genericTypeResource == null || genericTypeResource instanceof ImmutableGenericTypeResource) {
            return genericTypeResource;
        }
        return ImmutableGenericTypeResource.newBuilderFrom(genericTypeResource).build();
    }

    @Override
    public NodeResource getNodeResource() {
        return this.nodeResource;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getInstance() {
        return this.instance;
    }

    @Override
    public Resource.Type getResourceType() {
        return Resource.Type.GENERIC;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableGenericTypeResource that = (ImmutableGenericTypeResource)o;
        return Objects.equals(this.nodeResource, that.nodeResource) && Objects.equals(this.type, that.type) && Objects.equals(this.instance, that.instance);
    }

    public int hashCode() {
        return Objects.hash(this.nodeResource, this.type, this.instance);
    }

    public String toString() {
        return "ImmutableGenericTypeResource{nodeResource=" + this.nodeResource + ", type='" + this.type + "', instance='" + this.instance + "'}";
    }

    public static final class Builder {
        private NodeResource nodeResource;
        private String type;
        private String instance;

        private Builder() {
        }

        private Builder(GenericTypeResource genericTypeResource) {
            this.nodeResource = genericTypeResource.getNodeResource();
            this.type = genericTypeResource.getType();
            this.instance = genericTypeResource.getInstance();
        }

        public Builder setNodeResource(NodeResource nodeResource) {
            this.nodeResource = Objects.requireNonNull(nodeResource);
            return this;
        }

        public Builder setType(String type) {
            this.type = Objects.requireNonNull(type);
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = Objects.requireNonNull(instance);
            return this;
        }

        public GenericTypeResource build() {
            Objects.requireNonNull(this.nodeResource, "nodeResource is required");
            Objects.requireNonNull(this.type, "type is required");
            Objects.requireNonNull(this.instance, "instance is required");
            return new ImmutableGenericTypeResource(this);
        }
    }
}

