/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.srv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import org.opennms.integration.api.v1.timeseries.TimeSeriesStorage;
import org.opennms.plugins.cloud.srv.tsaas.TsaasStorage;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistrationManager {
    private static final Logger LOG = LoggerFactory.getLogger(RegistrationManager.class);
    private final BundleContext context;
    final TsaasStorage tsaas;
    private final Map<Service, ServiceRegistration<?>> registrations = new EnumMap(Service.class);

    public RegistrationManager(BundleContext context, TsaasStorage tsaas) {
        this.context = Objects.requireNonNull(context);
        this.tsaas = Objects.requireNonNull(tsaas);
    }

    public void register(Service service) {
        if (Service.TSAAS != service) {
            if (Service.FAAS == service) {
                throw new UnsupportedOperationException("please implement me");
            }
            throw new UnsupportedOperationException("please implement me");
        }
        this.register(Service.TSAAS, TimeSeriesStorage.class, this.tsaas);
    }

    private <T> void register(Service service, Class<T> interfaceToRegister, T serviceToRegister) {
        if (this.registrations.containsKey((Object)service)) {
            LOG.warn("Cannot register {}, its already registered.", (Object)service);
            return;
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("registration.export", "true");
        ServiceRegistration registration = this.context.registerService(interfaceToRegister, serviceToRegister, properties);
        this.registrations.put(service, registration);
        LOG.info("Registered {} ({}) with OpenNMS.", (Object)service, (Object)interfaceToRegister);
    }

    public void deregister(Service service) {
        ServiceRegistration<?> registration = this.registrations.get((Object)service);
        if (registration == null) {
            LOG.warn("Cannot deregister {}, it's not registered.", (Object)service);
            return;
        }
        registration.unregister();
        this.registrations.remove((Object)service);
        LOG.info("Deregistered {} with OpenNMS.", (Object)service);
    }

    public void destroy() {
        ArrayList<Service> servicesToDeRegister = new ArrayList<Service>(this.registrations.keySet());
        for (Service service : servicesToDeRegister) {
            this.deregister(service);
        }
    }

    public static enum Service {
        TSAAS,
        FAAS;


        public static boolean contains(String value) {
            return Arrays.stream(Service.values()).map(Enum::name).anyMatch(name -> name.equals(value));
        }
    }
}

