/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.util.filesstream;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FilesStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilesStream.class);

    private FilesStream() {
    }

    public static Stream<Path> stream(String fileNames) {
        if (fileNames == null) {
            return Stream.empty();
        }
        ArrayList<String> files = new ArrayList<String>();
        ArrayList<String> generators = new ArrayList<String>();
        StringBuilder buf = new StringBuilder(fileNames.length());
        boolean hasUnescapedReserved = false;
        boolean escaped = false;
        for (int i = 0; i < fileNames.length(); ++i) {
            char c = fileNames.charAt(i);
            if (escaped) {
                buf.append(c);
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == ',') {
                if (hasUnescapedReserved) {
                    generators.add(buf.toString());
                } else {
                    files.add(buf.toString());
                }
                hasUnescapedReserved = false;
                buf.setLength(0);
                continue;
            }
            if ("*?{[".indexOf(c) >= 0) {
                hasUnescapedReserved = true;
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        if (buf.length() > 0) {
            if (hasUnescapedReserved) {
                generators.add(buf.toString());
            } else {
                files.add(buf.toString());
            }
        }
        Path cur = Paths.get(System.getProperty("karaf.etc"), new String[0]);
        return Stream.concat(files.stream().map(cur::resolve), generators.stream().flatMap(s -> FilesStream.files(cur, s)));
    }

    private static Stream<Path> files(Path cur, String glob) {
        String rem;
        String prefix;
        int idx = glob.lastIndexOf(File.separatorChar);
        if (idx >= 0) {
            prefix = glob.substring(0, idx + 1);
            rem = glob.substring(idx + 1);
        } else {
            prefix = "";
            rem = glob;
        }
        final Path dir = cur.resolve(prefix);
        final PathMatcher matcher = dir.getFileSystem().getPathMatcher("glob:" + rem);
        final Stream.Builder stream = Stream.builder();
        try {
            Files.walkFileTree(dir, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.equals(dir)) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (Files.isHidden(file)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    Path r = dir.relativize(file);
                    if (matcher.matches(r)) {
                        stream.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path r;
                    if (!Files.isHidden(file) && matcher.matches(r = dir.relativize(file))) {
                        stream.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir2, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LOGGER.warn("Error generating filenames", e);
        }
        return stream.build();
    }
}

