/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.testserver;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import io.grpc.BindableService;
import io.grpc.stub.StreamObserver;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.opennms.dataplatform.access.AuthenticateGrpc;
import org.opennms.dataplatform.access.AuthenticateOuterClass;
import org.opennms.plugins.cloud.grpc.GrpcConnectionConfig;
import org.opennms.plugins.cloud.srv.RegistrationManager;
import org.opennms.plugins.cloud.testserver.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigGrpcImpl
extends AuthenticateGrpc.AuthenticateImplBase
implements BindableService {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigGrpcImpl.class);
    private GrpcConnectionConfig config;

    public void init(GrpcConnectionConfig config) {
        this.config = Objects.requireNonNull(config);
    }

    @Override
    public void authenticateKey(AuthenticateOuterClass.AuthenticateKeyRequest request, StreamObserver<AuthenticateOuterClass.AuthenticateKeyResponse> responseObserver) {
        LOG.info("authenticateKey() called.");
        if (this.config == null) {
            LOG.warn("call init() first.");
            responseObserver.onError(new IllegalAccessException("call init() first"));
            return;
        }
        AuthenticateOuterClass.AuthenticateKeyResponse response = AuthenticateOuterClass.AuthenticateKeyResponse.newBuilder().setCertificate(FileUtil.classpathFileToString("/cert/client_cert.crt")).setPrivateKey(FileUtil.classpathFileToString("/cert/client_private_key.key")).setGrpcEndpoint(this.config.getHost() + ":" + this.config.getPort()).build();
        responseObserver.onNext(response);
        responseObserver.onCompleted();
    }

    @Override
    public void getServices(AuthenticateOuterClass.GetServicesRequest request, StreamObserver<AuthenticateOuterClass.GetServicesResponse> responseObserver) {
        responseObserver.onNext(AuthenticateOuterClass.GetServicesResponse.newBuilder().putServices(RegistrationManager.Service.TSAAS.name(), AuthenticateOuterClass.Service.newBuilder().setEnabled(true).build()).putServices(RegistrationManager.Service.FAAS.name(), AuthenticateOuterClass.Service.newBuilder().setEnabled(false).build()).build());
        responseObserver.onCompleted();
    }

    @Override
    public void getAccessToken(AuthenticateOuterClass.GetAccessTokenRequest request, StreamObserver<AuthenticateOuterClass.GetAccessTokenResponse> responseObserver) {
        Algorithm algorithm = Algorithm.HMAC256("secret");
        String token = JWT.create().withExpiresAt(Instant.now().plus(1L, ChronoUnit.HOURS)).sign(algorithm);
        responseObserver.onNext(AuthenticateOuterClass.GetAccessTokenResponse.newBuilder().setToken(token).build());
        responseObserver.onCompleted();
    }

    @Override
    public void renewCertificate(AuthenticateOuterClass.RenewCertificateRequest request, StreamObserver<AuthenticateOuterClass.RenewCertificateResponse> responseObserver) {
        LOG.info("renewCertificate() called.");
        AuthenticateOuterClass.RenewCertificateResponse response = AuthenticateOuterClass.RenewCertificateResponse.newBuilder().setCertificate(FileUtil.classpathFileToString("/cert/client_cert.crt")).setPrivateKey(FileUtil.classpathFileToString("/cert/client_private_key.key")).build();
        responseObserver.onNext(response);
        responseObserver.onCompleted();
    }
}

