/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.felix.gogo.runtime.Closure;
import org.apache.karaf.shell.api.console.Command;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.apache.karaf.shell.impl.console.osgi.secured.SecuredCommand;
import org.apache.karaf.shell.impl.console.osgi.secured.SecuredSessionFactoryImpl;
import org.apache.karaf.shell.support.completers.ArgumentCommandLine;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

public class CommandsCompleter
extends org.apache.karaf.shell.support.completers.CommandsCompleter
implements Completer {
    private final SessionFactory factory;
    private final Session session;
    private final Map<String, org.apache.karaf.shell.api.console.Completer> globalCompleters = new HashMap<String, org.apache.karaf.shell.api.console.Completer>();
    private final Map<String, org.apache.karaf.shell.api.console.Completer> localCompleters = new HashMap<String, org.apache.karaf.shell.api.console.Completer>();
    private final org.apache.karaf.shell.api.console.Completer aliasesCompleter = new SimpleCommandCompleter(){

        @Override
        protected Collection<String> getNames(Session session) {
            return CommandsCompleter.this.getAliases(session);
        }
    };
    private final List<Command> commands = new ArrayList<Command>();

    public CommandsCompleter(SessionFactory factory, Session session) {
        this.factory = factory;
        this.session = session;
    }

    @Override
    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        CommandLineImpl commandLine = new CommandLineImpl(line);
        ArrayList<org.apache.karaf.shell.api.console.Candidate> cands = new ArrayList<org.apache.karaf.shell.api.console.Candidate>();
        this.completeCandidates(this.session, commandLine, cands);
        candidates.clear();
        for (org.apache.karaf.shell.api.console.Candidate cand : cands) {
            candidates.add(new Candidate(cand.value(), cand.displ(), cand.group(), cand.descr(), cand.suffix(), cand.key(), cand.complete()));
        }
    }

    @Override
    public void completeCandidates(Session session, CommandLine commandLine, List<org.apache.karaf.shell.api.console.Candidate> candidates) {
        Map<String, org.apache.karaf.shell.api.console.Completer>[] allCompleters = this.checkData();
        List<String> scopes = this.getCurrentScopes(session);
        this.sort(allCompleters, scopes);
        String subShell = this.getCurrentSubShell(session);
        String completion = this.getCompletionType(session);
        if ("subshell".equalsIgnoreCase(completion)) {
            if (subShell.isEmpty()) {
                subShell = "*";
            }
            ArrayList<org.apache.karaf.shell.api.console.Completer> completers = new ArrayList<org.apache.karaf.shell.api.console.Completer>();
            for (String name : allCompleters[1].keySet()) {
                if (!name.startsWith(subShell + ":")) continue;
                completers.add(allCompleters[1].get(name));
            }
            if (!subShell.equals("*")) {
                completers.add(new StringsCompleter(Collections.singletonList("exit")));
            }
            completers.forEach(c -> c.completeCandidates(session, commandLine, candidates));
            return;
        }
        if ("first".equalsIgnoreCase(completion)) {
            if (!subShell.isEmpty()) {
                ArrayList<org.apache.karaf.shell.api.console.Completer> completers = new ArrayList<org.apache.karaf.shell.api.console.Completer>();
                for (String name : allCompleters[1].keySet()) {
                    if (!name.startsWith(subShell + ":")) continue;
                    completers.add(allCompleters[1].get(name));
                }
                completers.forEach(c -> c.completeCandidates(session, commandLine, candidates));
                if (!candidates.isEmpty()) {
                    return;
                }
            }
            ArrayList<org.apache.karaf.shell.api.console.Completer> compl = new ArrayList<org.apache.karaf.shell.api.console.Completer>();
            compl.add(this.aliasesCompleter);
            compl.addAll(allCompleters[0].values());
            compl.forEach(c -> c.completeCandidates(session, commandLine, candidates));
            return;
        }
        ArrayList<org.apache.karaf.shell.api.console.Completer> compl = new ArrayList<org.apache.karaf.shell.api.console.Completer>();
        compl.add(this.aliasesCompleter);
        compl.addAll(allCompleters[0].values());
        compl.forEach(c -> c.completeCandidates(session, commandLine, candidates));
    }

    @Override
    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        ArrayList<org.apache.karaf.shell.api.console.Candidate> cands = new ArrayList<org.apache.karaf.shell.api.console.Candidate>();
        this.completeCandidates(session, commandLine, cands);
        for (org.apache.karaf.shell.api.console.Candidate cand : cands) {
            candidates.add(cand.value());
        }
        return 0;
    }

    protected void sort(Map<String, org.apache.karaf.shell.api.console.Completer>[] completers, List<String> scopes) {
        ScopeComparator comparator = new ScopeComparator(scopes);
        for (int i = 0; i < completers.length; ++i) {
            TreeMap<String, org.apache.karaf.shell.api.console.Completer> map = new TreeMap<String, org.apache.karaf.shell.api.console.Completer>(comparator);
            map.putAll(completers[i]);
            completers[i] = map;
        }
    }

    protected List<String> getCurrentScopes(Session session) {
        String scopes = (String)session.get("SCOPE");
        return Arrays.asList(scopes.split(":"));
    }

    protected String getCurrentSubShell(Session session) {
        String s = (String)session.get("SUBSHELL");
        if (s == null) {
            s = "";
        }
        return s;
    }

    protected String getCompletionType(Session session) {
        String completion = (String)session.get("karaf.completionMode");
        if (completion == null) {
            completion = "global";
        }
        return completion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, org.apache.karaf.shell.api.console.Completer>[] checkData() {
        boolean update;
        List<Command> commands;
        CommandsCompleter commandsCompleter = this;
        synchronized (commandsCompleter) {
            commands = this.factory.getRegistry().getCommands();
            update = !commands.equals(this.commands);
        }
        if (update) {
            HashMap<String, org.apache.karaf.shell.api.console.Completer> global = new HashMap<String, org.apache.karaf.shell.api.console.Completer>();
            HashMap<String, org.apache.karaf.shell.api.console.Completer> local = new HashMap<String, org.apache.karaf.shell.api.console.Completer>();
            for (Command command : commands) {
                String key = command.getScope() + ":" + command.getName();
                org.apache.karaf.shell.api.console.Completer cg = command.getCompleter(false);
                org.apache.karaf.shell.api.console.Completer cl = command.getCompleter(true);
                if (cg == null) {
                    cg = "*".equals(command.getScope()) ? new FixedSimpleCommandCompleter(Collections.singletonList(command.getName())) : new FixedSimpleCommandCompleter(Arrays.asList(key, command.getName()));
                }
                if (cl == null) {
                    cl = new FixedSimpleCommandCompleter(Collections.singletonList(command.getName()));
                }
                global.put(key, cg);
                local.put(key, cl);
            }
            CommandsCompleter commandsCompleter2 = this;
            synchronized (commandsCompleter2) {
                this.commands.clear();
                this.globalCompleters.clear();
                this.localCompleters.clear();
                this.commands.addAll(commands);
                this.globalCompleters.putAll(global);
                this.localCompleters.putAll(local);
            }
        }
        commandsCompleter = this;
        synchronized (commandsCompleter) {
            return new Map[]{new HashMap<String, org.apache.karaf.shell.api.console.Completer>(this.globalCompleters), new HashMap<String, org.apache.karaf.shell.api.console.Completer>(this.localCompleters)};
        }
    }

    private Set<String> getAliases(Session session) {
        Set vars = (Set)session.get(null);
        HashSet<String> aliases = new HashSet<String>();
        for (String var : vars) {
            Object content = session.get(var);
            if (content == null || !"org.apache.felix.gogo.runtime.Closure".equals(content.getClass().getName())) continue;
            int index = var.indexOf(":");
            if (index > 0 && this.factory instanceof SecuredSessionFactoryImpl) {
                String scope = var.substring(0, index);
                String command = var.substring(index + 1);
                String originalCmd = content.toString();
                index = originalCmd.indexOf(" ");
                Object securityCmd = null;
                if (index > 0) {
                    securityCmd = ((Closure)content).get(originalCmd.substring(0, index));
                }
                if (securityCmd instanceof SecuredCommand) {
                    if (!((SecuredSessionFactoryImpl)this.factory).isAliasVisible(scope, command) || !((SecuredSessionFactoryImpl)this.factory).isVisible(((SecuredCommand)securityCmd).getScope(), ((SecuredCommand)securityCmd).getName())) continue;
                    aliases.add(var);
                    continue;
                }
                if (!((SecuredSessionFactoryImpl)this.factory).isVisible(scope, command)) continue;
                aliases.add(var);
                continue;
            }
            aliases.add(var);
        }
        return aliases;
    }

    private static class CommandLineImpl
    implements CommandLine {
        private final ParsedLine line;

        public CommandLineImpl(ParsedLine line) {
            this.line = line;
        }

        @Override
        public int getCursorArgumentIndex() {
            return this.line.wordIndex();
        }

        @Override
        public String getCursorArgument() {
            return this.line.word();
        }

        @Override
        public int getArgumentPosition() {
            return this.line.wordCursor();
        }

        @Override
        public String[] getArguments() {
            return this.line.words().toArray(new String[this.line.words().size()]);
        }

        @Override
        public int getBufferPosition() {
            return this.line.cursor();
        }

        @Override
        public String getBuffer() {
            return this.line.line();
        }
    }

    static class FixedSimpleCommandCompleter
    extends SimpleCommandCompleter {
        private final Collection<String> names;

        FixedSimpleCommandCompleter(Collection<String> names) {
            this.names = names;
        }

        @Override
        protected Collection<String> getNames(Session session) {
            return this.names;
        }
    }

    static abstract class SimpleCommandCompleter
    implements org.apache.karaf.shell.api.console.Completer {
        SimpleCommandCompleter() {
        }

        @Override
        public int complete(Session session, CommandLine commandLine, List<String> candidates) {
            String[] args = commandLine.getArguments();
            int argIndex = commandLine.getCursorArgumentIndex();
            StringsCompleter completer = new StringsCompleter(this.getNames(session));
            if (argIndex == 0) {
                int res = completer.complete(session, new ArgumentCommandLine(args[argIndex], commandLine.getArgumentPosition()), candidates);
                if (res > -1) {
                    res += commandLine.getBufferPosition() - commandLine.getArgumentPosition();
                }
                return res;
            }
            if (!this.verifyCompleter(session, completer, args[0])) {
                return -1;
            }
            return 0;
        }

        protected abstract Collection<String> getNames(Session var1);

        private boolean verifyCompleter(Session session, org.apache.karaf.shell.api.console.Completer completer, String argument) {
            ArrayList<String> candidates = new ArrayList<String>();
            return completer.complete(session, new ArgumentCommandLine(argument, argument.length()), candidates) != -1 && !candidates.isEmpty();
        }
    }

    protected static class ScopeComparator
    implements Comparator<String> {
        private final List<String> scopes;

        public ScopeComparator(List<String> scopes) {
            this.scopes = scopes;
        }

        @Override
        public int compare(String o1, String o2) {
            String[] p1 = o1.split(":");
            String[] p2 = o2.split(":");
            int p = 0;
            while (p < p1.length && p < p2.length) {
                int i1 = this.scopes.indexOf(p1[p]);
                int i2 = this.scopes.indexOf(p2[p]);
                if (i1 < 0) {
                    if (i2 < 0) {
                        int c = p1[p].compareTo(p2[p]);
                        if (c != 0) {
                            return c;
                        }
                        ++p;
                        continue;
                    }
                    return 1;
                }
                if (i2 < 0) {
                    return -1;
                }
                if (i1 < i2) {
                    return -1;
                }
                if (i1 > i2) {
                    return 1;
                }
                ++p;
            }
            return 0;
        }
    }
}

