/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.support;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.shell.api.console.Session;
import org.jline.utils.AttributedString;
import org.jline.utils.StyleResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellUtil {
    public static final String DEFAULT_KS_COLORS = "em=31:ee=1;31:st=31";
    private static final Logger LOGGER = LoggerFactory.getLogger(ShellUtil.class);

    public static String getBundleName(Bundle bundle) {
        if (bundle != null) {
            String name = (String)bundle.getHeaders().get("Bundle-Name");
            return name == null ? "Bundle " + bundle.getBundleId() : name + " (" + bundle.getBundleId() + ")";
        }
        return "[STALE BUNDLE]";
    }

    public static String getUnderlineString(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            sb.append('-');
        }
        return sb.toString();
    }

    public static String getValueString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof Collection) {
            Object[] array = ((Collection)obj).toArray();
            return ShellUtil.getValueString(array);
        }
        if (obj.getClass().isArray()) {
            Object[] array = (Object[])obj;
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int i = 0; i < array.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(ShellUtil.getValueString(array[i]));
            }
            sb.append("]");
            return sb.toString();
        }
        return obj.toString();
    }

    public static boolean isASystemBundle(BundleContext bundleContext, Bundle bundle) {
        int level = ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel();
        int sbsl = 49;
        String sbslProp = bundleContext.getProperty("karaf.systemBundlesStartLevel");
        if (sbslProp != null) {
            try {
                sbsl = Integer.parseInt(sbslProp);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return level <= sbsl;
    }

    public static boolean getBoolean(Session session, String name) {
        Object s = session.get(name);
        if (s == null) {
            s = System.getProperty(name);
        }
        if (s == null) {
            return false;
        }
        if (s instanceof Boolean) {
            return (Boolean)s;
        }
        return Boolean.parseBoolean(s.toString());
    }

    public static void logException(Session session, Throwable t) {
        try {
            session.put("karaf.lastException", t);
            String name = t.getClass().getSimpleName();
            if ("CommandNotFoundException".equals(name)) {
                LOGGER.debug("Unknown command entered", t);
            } else if ("CommandException".equals(name)) {
                LOGGER.debug("Command exception (Undefined option, ...)", t);
            } else {
                LOGGER.error("Exception caught while executing command", t);
            }
            String pst = ShellUtil.getPrintStackTraces(session);
            Map<String, String> cm = ShellUtil.getKsColorMap(session);
            if ("always".equals(pst)) {
                String str = ShellUtil.applyStyle(ShellUtil.getStackTrace(t), cm, "st");
                session.getConsole().print(str);
            } else if ("CommandNotFoundException".equals(name)) {
                String str = ShellUtil.applyStyle("Command not found: ", cm, "em") + ShellUtil.applyStyle((String)t.getClass().getMethod("getCommand", new Class[0]).invoke((Object)t, new Object[0]), cm, "ee");
                session.getConsole().println(str);
            } else if ("CommandException".equals(name)) {
                String str;
                try {
                    str = (String)t.getClass().getMethod("getNiceHelp", new Class[0]).invoke((Object)t, new Object[0]);
                }
                catch (Throwable ignore) {
                    str = ShellUtil.applyStyle(t.getMessage(), cm, "em");
                }
                session.getConsole().println(str);
            } else if ("execution".equals(pst)) {
                String str = ShellUtil.applyStyle(ShellUtil.getStackTrace(t), cm, "st");
                session.getConsole().print(str);
            } else {
                String str = ShellUtil.applyStyle("Error executing command: ", cm, "em") + ShellUtil.applyStyle(t.getMessage() != null ? t.getMessage() : t.getClass().getName(), cm, "ee");
                session.getConsole().println(str);
            }
            session.getConsole().flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    private static String getPrintStackTraces(Session session) {
        Object pst = session.get("karaf.printStackTraces");
        if (pst == null) {
            pst = System.getProperty("karaf.printStackTraces");
        }
        if (pst == null) {
            return "never";
        }
        if (pst instanceof Boolean) {
            return (Boolean)pst != false ? "always" : "never";
        }
        return pst.toString().toLowerCase();
    }

    public static String getCurrentUserName() {
        AccessControlContext acc = AccessController.getContext();
        Subject subject = Subject.getSubject(acc);
        if (subject != null && subject.getPrincipals(UserPrincipal.class).iterator().hasNext()) {
            return subject.getPrincipals(UserPrincipal.class).iterator().next().getName();
        }
        return null;
    }

    static String applyStyle(String text, Map<String, String> colors, String ... types) {
        String t = null;
        for (String type : types) {
            if (colors.get(type) == null) continue;
            t = type;
            break;
        }
        return new AttributedString(text, new StyleResolver(colors::get).resolve("." + t)).toAnsi();
    }

    public static Map<String, String> getKsColorMap(Session session) {
        return ShellUtil.getColorMap(session, "KS", DEFAULT_KS_COLORS);
    }

    public static Map<String, String> getColorMap(Session session, String name, String def) {
        String str;
        Object obj = session.get(name + "_COLORS");
        String string = str = obj != null ? obj.toString() : null;
        if (str == null) {
            str = def;
        }
        String sep = str.matches("[a-z]{2}=[0-9]*(;[0-9]+)*(:[a-z]{2}=[0-9]*(;[0-9]+)*)*") ? ":" : " ";
        return Arrays.stream(str.split(sep)).collect(Collectors.toMap(s -> s.substring(0, s.indexOf(61)), s -> s.substring(s.indexOf(61) + 1)));
    }
}

