/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.support.completers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.karaf.shell.api.console.Candidate;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class FileCompleter
implements Completer {
    private static String OS = System.getProperty("os.name").toLowerCase();
    private static final boolean OS_IS_WINDOWS = FileCompleter.isWindows();

    public static boolean isWindows() {
        return OS.contains("win");
    }

    @Override
    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void completeCandidates(Session session, CommandLine commandLine, List<Candidate> candidates) {
        Path current;
        String curBuf;
        if (candidates == null) {
            return;
        }
        String buffer = commandLine.getCursorArgument().substring(0, commandLine.getArgumentPosition());
        if (OS_IS_WINDOWS) {
            buffer = buffer.replaceAll("/", File.separator);
        }
        Terminal terminal = (Terminal)session.get(".jline.terminal");
        int lastSep = buffer.lastIndexOf(this.separator());
        if (lastSep >= 0) {
            curBuf = buffer.substring(0, lastSep + 1);
            current = curBuf.startsWith("~") ? (curBuf.startsWith("~" + this.separator()) ? this.getUserHome().resolve(curBuf.substring(2)) : this.getUserHome().getParent().resolve(curBuf.substring(1))) : this.getUserDir().resolve(curBuf);
        } else {
            curBuf = "";
            current = this.getUserDir();
        }
        try {
            Files.newDirectoryStream(current, this::accept).forEach(p -> {
                String value = curBuf + p.getFileName().toString();
                if (Files.isDirectory(p, new LinkOption[0])) {
                    String s = OS_IS_WINDOWS ? "\\\\" : "/";
                    candidates.add(new Candidate(value + s, this.getDisplay(terminal, (Path)p), null, null, s, null, false));
                } else {
                    candidates.add(new Candidate(value, this.getDisplay(terminal, (Path)p), null, null, null, null, true));
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected boolean accept(Path path) {
        try {
            return !Files.isHidden(path);
        }
        catch (IOException e) {
            return false;
        }
    }

    protected String separator() {
        return File.separator;
    }

    protected Path getUserDir() {
        return Paths.get(System.getProperty("user.dir"), new String[0]);
    }

    protected Path getUserHome() {
        return Paths.get(System.getProperty("user.home"), new String[0]);
    }

    protected String getDisplay(Terminal terminal, Path p) {
        String name = p.getFileName().toString();
        if (Files.isDirectory(p, new LinkOption[0])) {
            AttributedStringBuilder sb = new AttributedStringBuilder();
            sb.style(AttributedStyle.BOLD.foreground(1));
            sb.append(name);
            sb.style(AttributedStyle.DEFAULT);
            sb.append(OS_IS_WINDOWS ? "\\\\" : "/");
            name = sb.toAnsi(terminal);
        } else if (Files.isSymbolicLink(p)) {
            AttributedStringBuilder sb = new AttributedStringBuilder();
            sb.style(AttributedStyle.BOLD.foreground(1));
            sb.append(name);
            sb.style(AttributedStyle.DEFAULT);
            sb.append("@");
            name = sb.toAnsi(terminal);
        }
        return name;
    }
}

