/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.collectors.resource.immutables;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opennms.integration.api.v1.collectors.immutables.ImmutableNumericAttribute;
import org.opennms.integration.api.v1.collectors.immutables.ImmutableStringAttribute;
import org.opennms.integration.api.v1.collectors.resource.CollectionSetResource;
import org.opennms.integration.api.v1.collectors.resource.GenericTypeResource;
import org.opennms.integration.api.v1.collectors.resource.IpInterfaceResource;
import org.opennms.integration.api.v1.collectors.resource.NodeResource;
import org.opennms.integration.api.v1.collectors.resource.NumericAttribute;
import org.opennms.integration.api.v1.collectors.resource.Resource;
import org.opennms.integration.api.v1.collectors.resource.StringAttribute;
import org.opennms.integration.api.v1.collectors.resource.immutables.ImmutableGenericTypeResource;
import org.opennms.integration.api.v1.collectors.resource.immutables.ImmutableIpInterfaceResource;
import org.opennms.integration.api.v1.collectors.resource.immutables.ImmutableNodeResource;
import org.opennms.integration.api.v1.util.ImmutableCollections;
import org.opennms.integration.api.v1.util.MutableCollections;

public final class ImmutableCollectionSetResource<T extends Resource>
implements CollectionSetResource {
    private final T resource;
    private final List<StringAttribute> stringAttributes;
    private final List<NumericAttribute> numericAttributes;

    private ImmutableCollectionSetResource(Builder<T> builder) {
        if (builder.resource != null) {
            switch (builder.resource.getResourceType()) {
                case NODE: {
                    this.resource = ImmutableNodeResource.immutableCopy((NodeResource)builder.resource);
                    break;
                }
                case GENERIC: {
                    this.resource = ImmutableGenericTypeResource.immutableCopy((GenericTypeResource)builder.resource);
                    break;
                }
                case INTERFACE: {
                    this.resource = ImmutableIpInterfaceResource.immutableCopy((IpInterfaceResource)builder.resource);
                    break;
                }
                default: {
                    this.resource = null;
                    break;
                }
            }
        } else {
            this.resource = null;
        }
        this.stringAttributes = ImmutableCollections.with(ImmutableStringAttribute::immutableCopy).newList(builder.stringAttributes);
        this.numericAttributes = ImmutableCollections.with(ImmutableNumericAttribute::immutableCopy).newList(builder.numericAttributes);
    }

    public static <T extends Resource> Builder<T> newBuilder(Class<T> clazz) {
        return new Builder();
    }

    public static <T extends Resource> Builder<T> newBuilderFrom(CollectionSetResource<T> collectionSetResource) {
        return new Builder<T>(collectionSetResource);
    }

    public static <T extends Resource> CollectionSetResource<T> immutableCopy(CollectionSetResource<T> collectionSetResource) {
        if (collectionSetResource == null || collectionSetResource instanceof ImmutableCollectionSetResource) {
            return collectionSetResource;
        }
        return ImmutableCollectionSetResource.newBuilderFrom(collectionSetResource).build();
    }

    public static CollectionSetResource typelessImmutableCopy(CollectionSetResource collectionSetResource) {
        return ImmutableCollectionSetResource.newBuilderFrom(collectionSetResource).build();
    }

    public Resource getResource() {
        return this.resource;
    }

    @Override
    public List<StringAttribute> getStringAttributes() {
        return this.stringAttributes;
    }

    @Override
    public List<NumericAttribute> getNumericAttributes() {
        return this.numericAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableCollectionSetResource that = (ImmutableCollectionSetResource)o;
        return Objects.equals(this.resource, that.resource) && Objects.equals(this.stringAttributes, that.stringAttributes) && Objects.equals(this.numericAttributes, that.numericAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.resource, this.stringAttributes, this.numericAttributes);
    }

    public String toString() {
        return "ImmutableCollectionSetResource{resource=" + this.resource + ", stringAttributes=" + this.stringAttributes + ", numericAttributes=" + this.numericAttributes + "}";
    }

    public static final class Builder<T extends Resource> {
        private T resource;
        private List<StringAttribute> stringAttributes;
        private List<NumericAttribute> numericAttributes;

        private Builder() {
        }

        private Builder(CollectionSetResource<T> collectionSetResource) {
            this.resource = collectionSetResource.getResource();
            this.stringAttributes = MutableCollections.copyListFromNullable(collectionSetResource.getStringAttributes());
            this.numericAttributes = MutableCollections.copyListFromNullable(collectionSetResource.getNumericAttributes());
        }

        public Builder<T> setResource(T resource) {
            this.resource = (Resource)Objects.requireNonNull(resource);
            return this;
        }

        public Builder<T> setStringAttributes(List<StringAttribute> stringAttributes) {
            this.stringAttributes = stringAttributes;
            return this;
        }

        public Builder<T> addStringAttribute(StringAttribute stringAttribute) {
            if (this.stringAttributes == null) {
                this.stringAttributes = new ArrayList<StringAttribute>();
            }
            this.stringAttributes.add(stringAttribute);
            return this;
        }

        public Builder<T> setNumericAttributes(List<NumericAttribute> numericAttributes) {
            this.numericAttributes = numericAttributes;
            return this;
        }

        public Builder<T> addNumericAttribute(NumericAttribute numericAttribute) {
            if (this.numericAttributes == null) {
                this.numericAttributes = new ArrayList<NumericAttribute>();
            }
            this.numericAttributes.add(numericAttribute);
            return this;
        }

        public CollectionSetResource<T> build() {
            Objects.requireNonNull(this.resource, "resource is required");
            return new ImmutableCollectionSetResource(this);
        }
    }
}

