/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.graph.immutables;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opennms.integration.api.v1.graph.GraphContainerInfo;
import org.opennms.integration.api.v1.graph.GraphInfo;
import org.opennms.integration.api.v1.graph.immutables.ImmutableGraphInfo;
import org.opennms.integration.api.v1.util.ImmutableCollections;

public final class ImmutableGraphContainerInfo
implements GraphContainerInfo {
    private final String containerId;
    private final String description;
    private final String label;
    private final List<GraphInfo> graphInfos;

    private ImmutableGraphContainerInfo(Builder builder) {
        this.containerId = builder.containerId;
        this.description = builder.description;
        this.label = builder.label;
        this.graphInfos = ImmutableCollections.with(ImmutableGraphInfo::immutableCopy).newList(builder.graphInfos);
        if (this.graphInfos.isEmpty()) {
            throw new IllegalArgumentException("graphInfos must not be empty");
        }
    }

    @Override
    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<GraphInfo> getGraphInfos() {
        return this.graphInfos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableGraphContainerInfo that = (ImmutableGraphContainerInfo)o;
        return Objects.equals(this.containerId, that.containerId) && Objects.equals(this.description, that.description) && Objects.equals(this.label, that.label) && Objects.equals(this.graphInfos, that.graphInfos);
    }

    public int hashCode() {
        return Objects.hash(this.containerId, this.description, this.label, this.graphInfos);
    }

    public String toString() {
        return "ImmutableGraphContainerInfo{containerId='" + this.containerId + "', description='" + this.description + "', label='" + this.label + "', graphInfos=" + this.graphInfos + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder newBuilder(String containerId, String label, String description, GraphInfo ... graphInfos) {
        Builder builder = new Builder().containerId(containerId).label(label).description(description);
        if (graphInfos != null) {
            for (GraphInfo eachGraphInfo : graphInfos) {
                builder.addGraphInfo(eachGraphInfo);
            }
        }
        return builder;
    }

    public static Builder newBuilderFrom(GraphContainerInfo fromGraphContainerInfo) {
        return new Builder().graphContainerInfo(fromGraphContainerInfo);
    }

    public static GraphContainerInfo immutableCopy(GraphContainerInfo graphContainerInfo) {
        if (graphContainerInfo == null || graphContainerInfo instanceof ImmutableGraphContainerInfo) {
            return graphContainerInfo;
        }
        return ImmutableGraphContainerInfo.newBuilderFrom(graphContainerInfo).build();
    }

    public static final class Builder {
        private String containerId;
        private String description;
        private String label;
        private List<GraphInfo> graphInfos = new ArrayList<GraphInfo>();

        public Builder containerId(String containerId) {
            this.containerId = Objects.requireNonNull(containerId);
            return this;
        }

        public Builder description(String description) {
            this.description = Objects.requireNonNull(description);
            return this;
        }

        public Builder label(String label) {
            this.label = Objects.requireNonNull(label);
            return this;
        }

        public Builder graphContainerInfo(GraphContainerInfo graphContainerInfo) {
            Objects.requireNonNull(graphContainerInfo);
            this.containerId(graphContainerInfo.getContainerId());
            this.description(graphContainerInfo.getContainerId());
            this.label(graphContainerInfo.getContainerId());
            return this;
        }

        public Builder addGraphInfo(GraphInfo graphInfo) {
            if (!this.graphInfos.contains(graphInfo)) {
                this.graphInfos.add(graphInfo);
            }
            return this;
        }

        public GraphContainerInfo build() {
            return new ImmutableGraphContainerInfo(this);
        }
    }
}

