/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.graph.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.graph.NodeRef;

public final class ImmutableNodeRef
implements NodeRef {
    private final String foreignSource;
    private final String foreignId;

    @Override
    public String getForeignSource() {
        return this.foreignSource;
    }

    @Override
    public String getForeignId() {
        return this.foreignId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder newBuilder(String nodeCriteria) {
        String[] split = nodeCriteria.split(":");
        if (split.length != 2) {
            throw new IllegalArgumentException("NodeCriteria is invalid. Must be of type <foreignSource>:<foreignId>");
        }
        return ImmutableNodeRef.newBuilder(split[0], split[1]);
    }

    public static Builder newBuilder(String foreignSource, String foreignId) {
        return new Builder().foreignSource(foreignSource).foreignId(foreignId);
    }

    public static Builder newBuilderFrom(NodeRef fromNodeRef) {
        return new Builder().foreignSource(fromNodeRef.getForeignSource()).foreignId(fromNodeRef.getForeignId());
    }

    public static NodeRef immutableCopy(NodeRef nodeRef) {
        if (nodeRef == null || nodeRef instanceof ImmutableNodeRef) {
            return nodeRef;
        }
        return ImmutableNodeRef.newBuilderFrom(nodeRef).build();
    }

    private ImmutableNodeRef(Builder builder) {
        Objects.requireNonNull(builder);
        this.foreignSource = builder.foreignSource;
        this.foreignId = builder.foreignId;
    }

    public static final class Builder {
        private String foreignSource;
        private String foreignId;

        private Builder() {
        }

        public Builder foreignSource(String foreignSource) {
            this.foreignSource = Objects.requireNonNull(foreignSource);
            return this;
        }

        public Builder foreignId(String foreignId) {
            this.foreignId = Objects.requireNonNull(foreignId);
            return this;
        }

        public NodeRef build() {
            return new ImmutableNodeRef(this);
        }
    }
}

