/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.model.immutables;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.opennms.integration.api.v1.model.MetaData;
import org.opennms.integration.api.v1.model.MonitoredService;
import org.opennms.integration.api.v1.model.immutables.ImmutableMetaData;
import org.opennms.integration.api.v1.util.ImmutableCollections;
import org.opennms.integration.api.v1.util.MutableCollections;

public final class ImmutableMonitoredService
implements MonitoredService {
    private final String name;
    private final List<MetaData> metaData;

    private ImmutableMonitoredService(String name, List<MetaData> metaData) {
        this.name = name;
        this.metaData = ImmutableCollections.with(ImmutableMetaData::immutableCopy).newList(metaData);
    }

    public static ImmutableMonitoredService newInstance(String name, List<MetaData> metaData) {
        return new ImmutableMonitoredService(Objects.requireNonNull(name), metaData);
    }

    public static MonitoredService immutableCopy(MonitoredService monitoredService) {
        if (monitoredService == null || monitoredService instanceof ImmutableMonitoredService) {
            return monitoredService;
        }
        return ImmutableMonitoredService.newInstance(monitoredService.getName(), monitoredService.getMetaData());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(MonitoredService monitoredService) {
        return new Builder(monitoredService);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<MetaData> getMetaData() {
        return this.metaData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableMonitoredService that = (ImmutableMonitoredService)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.metaData, that.metaData);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.metaData);
    }

    public String toString() {
        return "ImmutableIpInterface{name=" + this.name + ", metaData=" + this.metaData + "}";
    }

    public static final class Builder {
        private String name;
        private List<MetaData> metaData;

        private Builder() {
        }

        private Builder(MonitoredService monitoredService) {
            this.name = monitoredService.getName();
            this.metaData = MutableCollections.copyListFromNullable(monitoredService.getMetaData(), LinkedList::new);
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setMetaData(List<MetaData> metaData) {
            this.metaData = metaData;
            return this;
        }

        public Builder addMetaData(MetaData metaData) {
            if (this.metaData == null) {
                this.metaData = new LinkedList<MetaData>();
            }
            this.metaData.add(metaData);
            return this;
        }

        public ImmutableMonitoredService build() {
            return ImmutableMonitoredService.newInstance(this.name, this.metaData);
        }
    }
}

