/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.pollers.immutables;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opennms.integration.api.v1.pollers.PollerResult;
import org.opennms.integration.api.v1.pollers.Status;
import org.opennms.integration.api.v1.util.ImmutableCollections;
import org.opennms.integration.api.v1.util.MutableCollections;

public final class ImmutablePollerResult
implements PollerResult {
    private final Status status;
    private final String reason;
    private final Map<String, Number> properties;

    private ImmutablePollerResult(Builder builder) {
        this.status = builder.status;
        this.reason = builder.reason;
        this.properties = ImmutableCollections.newMapOfImmutableTypes(builder.properties);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(PollerResult pollerResult) {
        return new Builder(pollerResult);
    }

    public static PollerResult immutableCopy(PollerResult pollerResult) {
        if (pollerResult == null || pollerResult instanceof ImmutablePollerResult) {
            return pollerResult;
        }
        return ImmutablePollerResult.newBuilderFrom(pollerResult).build();
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public Map<String, Number> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutablePollerResult that = (ImmutablePollerResult)o;
        return this.status == that.status && Objects.equals(this.reason, that.reason) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.reason, this.properties});
    }

    public String toString() {
        return "ImmutablePollerResult{status=" + this.status + ", reason='" + this.reason + "', properties=" + this.properties + "}";
    }

    public static final class Builder {
        private Status status;
        private String reason;
        private Map<String, Number> properties;

        private Builder() {
        }

        private Builder(PollerResult pollerResult) {
            this.status = pollerResult.getStatus();
            this.reason = pollerResult.getReason();
            this.properties = MutableCollections.copyMapFromNullable(pollerResult.getProperties());
        }

        public Builder setStatus(Status status) {
            this.status = status;
            return this;
        }

        public Builder setReason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder setProperties(Map<String, Number> properties) {
            this.properties = properties;
            return this;
        }

        public Builder addProperty(String key, Number value) {
            if (this.properties == null) {
                this.properties = new HashMap<String, Number>();
            }
            this.properties.put(key, value);
            return this;
        }

        public ImmutablePollerResult build() {
            return new ImmutablePollerResult(this);
        }
    }
}

