/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.timeseries.immutables;

import java.io.Serializable;
import java.util.Objects;
import java.util.StringJoiner;
import org.opennms.integration.api.v1.timeseries.Tag;
import org.opennms.integration.api.v1.timeseries.TagMatcher;

public class ImmutableTagMatcher
implements TagMatcher,
Serializable {
    private final TagMatcher.Type type;
    private final String key;
    private final String value;

    public ImmutableTagMatcher(TagMatcher.Type type, String key, String value) {
        this.type = Objects.requireNonNull(type);
        this.key = Objects.requireNonNull(key);
        this.value = Objects.requireNonNull(value);
    }

    @Override
    public TagMatcher.Type getType() {
        return this.type;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableTagMatcher that = (ImmutableTagMatcher)o;
        return this.type == that.type && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.key, this.value});
    }

    public String toString() {
        return new StringJoiner(", ", ImmutableTagMatcher.class.getSimpleName() + "[", "]").add("type=" + this.type).add("key='" + this.key + "'").add("value='" + this.value + "'").toString();
    }

    public static TagMatcherBuilder builder() {
        return new TagMatcherBuilder();
    }

    public static final class TagMatcherBuilder {
        private TagMatcher.Type type = TagMatcher.Type.EQUALS;
        private String key;
        private String value;

        public TagMatcherBuilder type(TagMatcher.Type type) {
            this.type = type;
            return this;
        }

        public TagMatcherBuilder key(String key) {
            this.key = key;
            return this;
        }

        public TagMatcherBuilder value(String value) {
            this.value = value;
            return this;
        }

        public static TagMatcherBuilder of(Tag tag) {
            return new TagMatcherBuilder().key(tag.getKey()).value(tag.getValue());
        }

        public TagMatcher build() {
            return new ImmutableTagMatcher(this.type, this.key, this.value);
        }
    }
}

