/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.config;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.dataplatform.access.AuthenticateGrpc;
import org.opennms.dataplatform.access.AuthenticateOuterClass;
import org.opennms.plugins.cloud.config.ConfigStore;
import org.opennms.plugins.cloud.grpc.GrpcConnection;
import org.opennms.plugins.cloud.srv.RegistrationManager;

class PasAccess {
    final GrpcConnection<AuthenticateGrpc.AuthenticateBlockingStub> grpc;

    PasAccess(GrpcConnection<AuthenticateGrpc.AuthenticateBlockingStub> grpc) {
        this.grpc = Objects.requireNonNull(grpc);
    }

    Map<ConfigStore.Key, String> getCredentialsFromAccessService(String key, String systemId) {
        AuthenticateOuterClass.AuthenticateKeyRequest keyRequest = AuthenticateOuterClass.AuthenticateKeyRequest.newBuilder().setAuthenticationKey(key).setSystemUuid(systemId).build();
        AuthenticateOuterClass.AuthenticateKeyResponse response = this.grpc.get().authenticateKey(keyRequest);
        EnumMap<ConfigStore.Key, String> attributes = new EnumMap<ConfigStore.Key, String>(ConfigStore.Key.class);
        if (response.getGrpcEndpoint().contains(":")) {
            String[] split = response.getGrpcEndpoint().split(":");
            attributes.put(ConfigStore.Key.grpchost, split[0]);
            attributes.put(ConfigStore.Key.grpcport, split[1]);
        }
        attributes.put(ConfigStore.Key.privatekey, response.getPrivateKey());
        attributes.put(ConfigStore.Key.publickey, response.getCertificate());
        return attributes;
    }

    Set<RegistrationManager.Service> getActiveServices(String systemId) {
        AuthenticateOuterClass.GetServicesResponse servicesResponse = this.grpc.get().getServices(AuthenticateOuterClass.GetServicesRequest.newBuilder().setSystemId(systemId).build());
        return servicesResponse.getServicesMap().entrySet().stream().filter(e -> ((AuthenticateOuterClass.Service)e.getValue()).getEnabled()).map(Map.Entry::getKey).map(RegistrationManager.Service::valueOf).collect(Collectors.toSet());
    }

    String getToken(Set<RegistrationManager.Service> activeServices, String systemId) {
        AuthenticateOuterClass.GetAccessTokenRequest request = AuthenticateOuterClass.GetAccessTokenRequest.newBuilder().addAllServices(activeServices.stream().map(Enum::name).collect(Collectors.toList())).setSystemUuid(systemId).build();
        AuthenticateOuterClass.GetAccessTokenResponse response = this.grpc.get().getAccessToken(request);
        return response.getToken();
    }

    public Map<ConfigStore.Key, String> renewCertificate(String systemId) {
        AuthenticateOuterClass.RenewCertificateResponse response = this.grpc.get().renewCertificate(AuthenticateOuterClass.RenewCertificateRequest.newBuilder().setSystemUuid(systemId).build());
        EnumMap<ConfigStore.Key, String> attributes = new EnumMap<ConfigStore.Key, String>(ConfigStore.Key.class);
        attributes.put(ConfigStore.Key.privatekey, response.getPrivateKey());
        attributes.put(ConfigStore.Key.publickey, response.getCertificate());
        return attributes;
    }
}

