/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.integration.api.v1.scv.Credentials;
import org.opennms.integration.api.v1.scv.SecureCredentialsVault;
import org.opennms.plugins.cloud.config.ConfigStore;
import org.opennms.plugins.cloud.config.KvConfigStore;
import org.opennms.plugins.cloud.config.ScvConfigStore;

public class SvcConfigStoreTest {
    @Test
    public void shouldFailForNullStore() {
        Assert.assertThrows(NullPointerException.class, () -> new KvConfigStore(null));
    }

    @Test
    public void shouldRunCrud() {
        ScvConfigStore store = new ScvConfigStore(new InMemoryScvConfigStore());
        Assert.assertEquals(Optional.empty(), store.get(ConfigStore.Key.tokenvalue));
        Assert.assertNull(store.getOrNull(ConfigStore.Key.tokenvalue));
        store.putProperty(ConfigStore.Key.tokenvalue, "value");
        Assert.assertEquals("value", store.get(ConfigStore.Key.tokenvalue).get());
        Assert.assertEquals("value", store.getOrNull(ConfigStore.Key.tokenvalue));
        store.putProperty(ConfigStore.Key.tokenvalue, "value2");
        Assert.assertEquals("value2", store.get(ConfigStore.Key.tokenvalue).get());
        Assert.assertEquals("value2", store.getOrNull(ConfigStore.Key.tokenvalue));
        HashMap<ConfigStore.Key, String> map = new HashMap<ConfigStore.Key, String>();
        map.put(ConfigStore.Key.tokenvalue, "value3");
        map.put(ConfigStore.Key.tokenkey, "key1");
        store.putProperties(map);
        Assert.assertEquals("value3", store.get(ConfigStore.Key.tokenvalue).get());
        Assert.assertEquals("value3", store.getOrNull(ConfigStore.Key.tokenvalue));
        Assert.assertEquals("key1", store.get(ConfigStore.Key.tokenkey).get());
        Assert.assertEquals("key1", store.getOrNull(ConfigStore.Key.tokenkey));
    }

    private static class InMemoryScvConfigStore
    implements SecureCredentialsVault {
        private Credentials credentials;

        private InMemoryScvConfigStore() {
        }

        @Override
        public Set<String> getAliases() {
            return Collections.singleton("plugin.cloud");
        }

        @Override
        public Credentials getCredentials(String alias) {
            Assert.assertEquals("plugin.cloud", alias);
            return this.credentials;
        }

        @Override
        public void setCredentials(String alias, Credentials credentials) {
            this.credentials = credentials;
        }
    }
}

