/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.config.shell;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opennms.integration.api.v1.runtime.Container;
import org.opennms.integration.api.v1.runtime.RuntimeInfo;
import org.opennms.plugins.cloud.config.ConfigurationManager;
import org.opennms.plugins.cloud.config.shell.InitCloud;

public class InitCloudTest {
    private RuntimeInfo info;
    private ConfigurationManager manager;
    private InitCloud cmd;

    @Before
    public void setUp() {
        this.info = (RuntimeInfo)Mockito.mock(RuntimeInfo.class);
        Mockito.when((Object)((Object)this.info.getContainer())).thenReturn((Object)Container.OPENNMS);
        this.manager = (ConfigurationManager)Mockito.mock(ConfigurationManager.class);
        this.cmd = new InitCloud();
        this.cmd.runtimeInfo = this.info;
        this.cmd.manager = this.manager;
        this.cmd.apiKey = "apiKey";
    }

    @Test
    public void shouldTalkToPasForCore() {
        this.cmd.execute();
        ((ConfigurationManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.times((int)1))).initConfiguration(ArgumentMatchers.anyString());
        ((ConfigurationManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.times((int)1))).configure();
    }

    @Test
    public void shouldRejectMissingApiKey() {
        this.cmd.apiKey = null;
        Assert.assertThrows(NullPointerException.class, this.cmd::execute);
        ((ConfigurationManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.never())).initConfiguration(ArgumentMatchers.anyString());
        ((ConfigurationManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.never())).configure();
    }

    @Test
    public void shouldTalkToDbForSentinel() {
        Mockito.when((Object)((Object)this.info.getContainer())).thenReturn((Object)Container.SENTINEL);
        this.cmd.execute();
        ((ConfigurationManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.never())).initConfiguration(ArgumentMatchers.anyString());
        ((ConfigurationManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.times((int)1))).configure();
    }

    @Test
    public void shouldRejectUnsupportedContainer() {
        Mockito.when((Object)((Object)this.info.getContainer())).thenReturn((Object)Container.MINION);
        this.cmd.execute();
        ((ConfigurationManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.never())).initConfiguration(ArgumentMatchers.anyString());
        ((ConfigurationManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.never())).configure();
    }
}

