/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.grpc;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSsl;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import io.grpc.stub.AbstractBlockingStub;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.net.ssl.SSLException;
import org.opennms.plugins.cloud.grpc.GrpcConnectionConfig;
import org.opennms.plugins.cloud.srv.tsaas.grpc.comp.ZstdCodecRegisterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcConnection<T extends AbstractBlockingStub<T>>
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcConnection.class);
    private static final int MAX_MESSAGE_SIZE = 0x6400000;
    @VisibleForTesting
    public final ManagedChannel managedChannel;
    private final T clientStub;

    public GrpcConnection(GrpcConnectionConfig config, Function<ManagedChannel, T> stubCreator) {
        NettyChannelBuilder builder = NettyChannelBuilder.forAddress(config.getHost(), config.getPort());
        builder.sslContext(this.createSslContext(config));
        builder.maxInboundMessageSize(0x6400000).maxInboundMetadataSize(0x6400000).keepAliveTime(10L, TimeUnit.SECONDS).keepAliveTimeout(5L, TimeUnit.SECONDS).keepAliveWithoutCalls(true);
        this.managedChannel = ((NettyChannelBuilder)((NettyChannelBuilder)builder.compressorRegistry(ZstdCodecRegisterUtil.createCompressorRegistry())).decompressorRegistry(ZstdCodecRegisterUtil.createDecompressorRegistry())).build();
        this.clientStub = (AbstractBlockingStub)((AbstractBlockingStub)((AbstractBlockingStub)stubCreator.apply(this.managedChannel)).withCompression("gzip")).withInterceptors(new TokenAddingInterceptor(config.getTokenKey(), config.getTokenValue()));
    }

    public GrpcConnection(T clientStub, ManagedChannel managedChannel) {
        this.clientStub = (AbstractBlockingStub)Objects.requireNonNull(clientStub);
        this.managedChannel = Objects.requireNonNull(managedChannel);
    }

    public T get() {
        return this.clientStub;
    }

    private SslContext createSslContext(GrpcConnectionConfig config) {
        Objects.requireNonNull(config);
        try {
            SslProvider provider = OpenSsl.isAvailable() && SslProvider.isAlpnSupported(SslProvider.OPENSSL) ? SslProvider.OPENSSL : SslProvider.JDK;
            LOG.info("Using SSL provider {}, ", (Object)provider);
            SslContextBuilder context = GrpcSslContexts.configure(GrpcSslContexts.forClient(), provider);
            String truststore = config.getClientTrustStore();
            if (truststore == null || truststore.isBlank()) {
                LOG.info("Will use jvm truststore.");
            } else {
                LOG.info("Will use truststore from ConfigStore.");
                context.trustManager(new ByteArrayInputStream(truststore.getBytes(StandardCharsets.UTF_8)));
            }
            if (GrpcConnectionConfig.Security.MTLS == config.getSecurity()) {
                context.keyManager(new ByteArrayInputStream(config.getPublicKey().getBytes(StandardCharsets.UTF_8)), new ByteArrayInputStream(config.getPrivateKey().getBytes(StandardCharsets.UTF_8))).clientAuth(ClientAuth.REQUIRE);
            }
            return context.build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.managedChannel.shutdownNow();
        try {
            this.managedChannel.awaitTermination(15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static class TokenAddingInterceptor
    implements ClientInterceptor {
        final String tokenKey;
        final String tokenValue;

        TokenAddingInterceptor(String tokenKey, String tokenValue) {
            this.tokenKey = tokenKey;
            this.tokenValue = tokenValue;
        }

        public <I, O> ClientCall<I, O> interceptCall(MethodDescriptor<I, O> method, CallOptions callOptions, Channel next) {
            return new ForwardingClientCall.SimpleForwardingClientCall<I, O>(next.newCall(method, callOptions)){

                @Override
                public void start(ClientCall.Listener<O> responseListener, Metadata headers) {
                    if (TokenAddingInterceptor.isNotEmpty(tokenKey) && TokenAddingInterceptor.isNotEmpty(tokenValue)) {
                        headers.put(Metadata.Key.of(tokenKey, Metadata.ASCII_STRING_MARSHALLER), tokenValue);
                    }
                    super.start(responseListener, headers);
                }
            };
        }

        private static boolean isNotEmpty(String s) {
            return s != null && !s.isBlank();
        }
    }
}

