/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.srv.tsaas;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.opennms.integration.api.v1.timeseries.AbstractStorageIntegrationTest;
import org.opennms.integration.api.v1.timeseries.TimeSeriesStorage;
import org.opennms.plugins.cloud.grpc.GrpcConnectionConfig;
import org.opennms.plugins.cloud.srv.tsaas.TsaasConfig;
import org.opennms.plugins.cloud.srv.tsaas.TsaasStorage;
import org.opennms.plugins.cloud.testserver.MockCloud;
import org.opennms.tsaas.Tsaas;

public class TsaasStorageTest
extends AbstractStorageIntegrationTest {
    @Rule
    public final MockCloud cloud = MockCloud.builder().build();
    private TsaasStorage storage;

    @Override
    @Before
    public void setUp() throws Exception {
        GrpcConnectionConfig clientConfig = this.cloud.getClientConfigWithToken();
        TsaasConfig tsaasConfig = TsaasConfig.builder().batchSize(1).build();
        this.storage = new TsaasStorage(tsaasConfig);
        this.storage.initGrpc(clientConfig);
        super.setUp();
    }

    @After
    public void tearDown() throws InterruptedException {
        if (this.storage != null) {
            this.storage.destroy();
        }
    }

    @Override
    protected TimeSeriesStorage createStorage() throws Exception {
        return this.storage;
    }

    @Override
    @Test
    @Ignore(value="we don't implement delete(), hence @Ignore")
    public void shouldDeleteMetrics() throws Exception {
    }

    @Test
    public void shouldReturnHealthStatus() {
        Tsaas.CheckHealthResponse health = this.storage.checkHealth();
        Assert.assertNotNull(health);
        Assert.assertEquals(Tsaas.CheckHealthResponse.ServingStatus.SERVING, health.getStatus());
    }
}

