/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.srv.tsaas;

import java.time.Instant;
import java.util.Collections;
import java.util.List;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opennms.integration.api.v1.timeseries.Sample;
import org.opennms.integration.api.v1.timeseries.StorageException;
import org.opennms.integration.api.v1.timeseries.TimeSeriesStorage;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableMetric;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableSample;
import org.opennms.plugins.cloud.srv.tsaas.TsaasConfig;
import org.opennms.plugins.cloud.srv.tsaas.TsaasStorage;
import org.opennms.plugins.cloud.testserver.MockCloud;

public class TsaasStorageBatchStoringTest {
    @Rule
    public MockCloud cloud = MockCloud.builder().serverStorage((TimeSeriesStorage)Mockito.mock(TimeSeriesStorage.class)).build();

    @Test
    public void shouldSendStoreSamplesAfterWaitTime() throws StorageException, InterruptedException {
        TsaasConfig tsaasConfig = TsaasConfig.builder().batchSize(10).maxBatchWaitTimeInMilliSeconds(500L).build();
        TsaasStorage plugin = new TsaasStorage(tsaasConfig);
        plugin.initGrpc(this.cloud.getClientConfigWithToken());
        plugin.store(this.createSamples());
        plugin.store(this.createSamples());
        ((TimeSeriesStorage)Mockito.verify((Object)this.cloud.getServerStorage(), (VerificationMode)Mockito.never())).store((List)ArgumentMatchers.any());
        Thread.sleep(tsaasConfig.getMaxBatchWaitTimeInMilliSeconds() + 10L);
        plugin.store(this.createSamples());
        ((TimeSeriesStorage)Mockito.verify((Object)this.cloud.getServerStorage(), (VerificationMode)Mockito.times((int)1))).store((List)ArgumentMatchers.argThat(l -> l.size() == 3));
        Mockito.clearInvocations((Object[])new TimeSeriesStorage[]{this.cloud.getServerStorage()});
        plugin.store(this.createSamples());
        plugin.store(this.createSamples());
        ((TimeSeriesStorage)Mockito.verify((Object)this.cloud.getServerStorage(), (VerificationMode)Mockito.never())).store((List)ArgumentMatchers.any());
        Thread.sleep(tsaasConfig.getMaxBatchWaitTimeInMilliSeconds() + 10L);
        plugin.store(this.createSamples());
        ((TimeSeriesStorage)Mockito.verify((Object)this.cloud.getServerStorage(), (VerificationMode)Mockito.times((int)1))).store((List)ArgumentMatchers.argThat(l -> l.size() == 3));
    }

    private List<Sample> createSamples() {
        return Collections.singletonList(ImmutableSample.builder().time(Instant.now()).metric(ImmutableMetric.builder().intrinsicTag("resourceId", "a").intrinsicTag("name", "b").build()).value(3.0).build());
    }
}

