/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.srv.tsaas.shell;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Random;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.integration.api.v1.timeseries.Sample;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableMetric;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableSample;
import org.opennms.plugins.cloud.srv.tsaas.TsaasStorage;

@Command(scope="opennms-tsaas", name="write-samples", description="Write samples.")
@Service
public class MetricWrite
implements Action {
    @Reference
    TsaasStorage tss;
    @Option(name="count")
    int count = 1;

    @Override
    public Object execute() throws Exception {
        if (this.count < 1) {
            throw new IllegalArgumentException("Count must be > 0");
        }
        Random random = new Random(42L);
        ImmutableMetric metric = ImmutableMetric.builder().intrinsicTag("resourceId", "response:127.0.0.1:icmp").intrinsicTag("name", "icmp").metaTag("_idx2", "(response:127.0.0.1:icmp,3)").metaTag("mtype", "gauge").metaTag("ICMP/127.0.0.1", "icmp").metaTag("_idx0", "(response,3)").metaTag("_idx1", "(response:127.0.0.1,3)").metaTag("_idx2w", "(response:127.0.0.1,*)").build();
        ArrayList<Sample> samples = new ArrayList<Sample>();
        for (long l = (long)this.count; l > 0L; --l) {
            samples.add(ImmutableSample.builder().metric(metric).value((double)random.nextInt(5000) + 3000.0).time(Instant.now().minus(l * 10L, ChronoUnit.MINUTES)).build());
        }
        System.out.printf("Storing %s samples.%n", this.count);
        this.tss.store(samples);
        System.out.println("Done.");
        return null;
    }
}

