/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.grpc;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.integration.api.v1.timeseries.StorageException;
import org.opennms.plugins.cloud.grpc.GrpcExceptionHandler;

public class GrpcExceptionHandlerTest {
    @Test
    public void shouldSwallowNonRecoverableExceptions() throws StorageException {
        GrpcExceptionHandler.executeRpcCall(() -> {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        });
        GrpcExceptionHandler.executeRpcCall(() -> {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }, s -> s, () -> "");
    }

    @Test
    public void shouldRethrowRecoverableExceptions() {
        Assert.assertThrows(StorageException.class, () -> GrpcExceptionHandler.executeRpcCall(() -> {
            throw new StatusRuntimeException(Status.UNAVAILABLE);
        }));
        Assert.assertThrows(StorageException.class, () -> GrpcExceptionHandler.executeRpcCall(() -> {
            throw new StatusRuntimeException(Status.UNAVAILABLE);
        }, s -> s, () -> ""));
    }
}

