/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.srv.tsaas;

import java.util.Objects;
import org.opennms.integration.api.v1.health.Context;
import org.opennms.integration.api.v1.health.HealthCheck;
import org.opennms.integration.api.v1.health.Response;
import org.opennms.integration.api.v1.health.Status;
import org.opennms.integration.api.v1.health.immutables.ImmutableResponse;
import org.opennms.plugins.cloud.config.ConfigurationManager;
import org.opennms.plugins.cloud.srv.tsaas.TsaasStorage;
import org.opennms.tsaas.Tsaas;

public class CloudHealthCheck
implements HealthCheck {
    private final ConfigurationManager cm;
    private final TsaasStorage cloud;

    public CloudHealthCheck(ConfigurationManager cm, TsaasStorage cloud) {
        this.cm = Objects.requireNonNull(cm);
        this.cloud = Objects.requireNonNull(cloud);
    }

    @Override
    public String getDescription() {
        return "Cloud status";
    }

    @Override
    public Response perform(Context context) throws Exception {
        String message;
        Status status;
        if (this.cm.getStatus() == ConfigurationManager.ConfigStatus.FAILED) {
            status = Status.Failure;
            message = String.format("Cloud init failed (status=%s)", new Object[]{ConfigurationManager.ConfigStatus.FAILED});
        } else if (this.cm.getStatus() == ConfigurationManager.ConfigStatus.NOT_ATTEMPTED) {
            status = Status.Success;
            message = String.format("Cloud init not attempted (status=%s)", new Object[]{ConfigurationManager.ConfigStatus.NOT_ATTEMPTED});
        } else if (this.cm.getStatus() == ConfigurationManager.ConfigStatus.AUTHENTCATED) {
            status = Status.Starting;
            message = String.format("Cloud init successful, configuration has not happened yet (status=%s)", new Object[]{ConfigurationManager.ConfigStatus.AUTHENTCATED});
        } else {
            Tsaas.CheckHealthResponse response = this.cloud.checkHealth();
            status = this.toStatus(response.getStatus());
            message = String.format("Cloud status=%s", response.getStatus().name());
        }
        return ImmutableResponse.newInstance(status, message);
    }

    private Status toStatus(Tsaas.CheckHealthResponse.ServingStatus cloudStatus) {
        if (cloudStatus == Tsaas.CheckHealthResponse.ServingStatus.SERVING) {
            return Status.Success;
        }
        return Status.Failure;
    }
}

