/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.srv.tsaas;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.opennms.integration.api.v1.health.Context;
import org.opennms.integration.api.v1.health.Response;
import org.opennms.integration.api.v1.health.Status;
import org.opennms.plugins.cloud.config.ConfigurationManager;
import org.opennms.plugins.cloud.srv.tsaas.CloudHealthCheck;
import org.opennms.plugins.cloud.srv.tsaas.TsaasStorage;
import org.opennms.tsaas.Tsaas;

public class CloudHealthCheckTest {
    private ConfigurationManager cm;

    @Before
    public void setUp() throws Exception {
        this.cm = (ConfigurationManager)Mockito.mock(ConfigurationManager.class);
    }

    @Test
    public void shouldReturnStatusForTsaasSuccess() throws Exception {
        Mockito.when((Object)this.cm.getStatus()).thenReturn((Object)ConfigurationManager.ConfigStatus.CONFIGURED);
        TsaasStorage storage = (TsaasStorage)Mockito.mock(TsaasStorage.class);
        Mockito.when((Object)storage.checkHealth()).thenReturn((Object)Tsaas.CheckHealthResponse.newBuilder().setStatus(Tsaas.CheckHealthResponse.ServingStatus.SERVING).build());
        Assert.assertEquals((Object)Tsaas.CheckHealthResponse.ServingStatus.SERVING, (Object)storage.checkHealth().getStatus());
        Response response = new CloudHealthCheck(this.cm, storage).perform((Context)Mockito.mock(Context.class));
        Assert.assertEquals((Object)Status.Success, (Object)response.getStatus());
        Assert.assertTrue((boolean)response.getMessage().contains(Tsaas.CheckHealthResponse.ServingStatus.SERVING.name()));
    }

    @Test
    public void shouldReturnStatusForTsaasFailure() throws Exception {
        Mockito.when((Object)this.cm.getStatus()).thenReturn((Object)ConfigurationManager.ConfigStatus.CONFIGURED);
        TsaasStorage tsaas = (TsaasStorage)Mockito.mock(TsaasStorage.class);
        Mockito.when((Object)tsaas.checkHealth()).thenReturn((Object)Tsaas.CheckHealthResponse.newBuilder().setStatus(Tsaas.CheckHealthResponse.ServingStatus.NOT_SERVING).build());
        Response response = new CloudHealthCheck(this.cm, tsaas).perform((Context)Mockito.mock(Context.class));
        Assert.assertEquals((Object)Status.Failure, (Object)response.getStatus());
        Assert.assertTrue((boolean)response.getMessage().contains(Tsaas.CheckHealthResponse.ServingStatus.SERVING.name()));
    }

    @Test
    public void shouldReturnStatusForInitNotAttempted() throws Exception {
        Mockito.when((Object)this.cm.getStatus()).thenReturn((Object)ConfigurationManager.ConfigStatus.NOT_ATTEMPTED);
        TsaasStorage tsaas = (TsaasStorage)Mockito.mock(TsaasStorage.class);
        Response response = new CloudHealthCheck(this.cm, tsaas).perform((Context)Mockito.mock(Context.class));
        Assert.assertEquals((Object)Status.Success, (Object)response.getStatus());
        Assert.assertTrue((boolean)response.getMessage().contains(ConfigurationManager.ConfigStatus.NOT_ATTEMPTED.name()));
    }

    @Test
    public void shouldReturnStatusForInitFailed() throws Exception {
        Mockito.when((Object)this.cm.getStatus()).thenReturn((Object)ConfigurationManager.ConfigStatus.FAILED);
        TsaasStorage tsaas = (TsaasStorage)Mockito.mock(TsaasStorage.class);
        Response response = new CloudHealthCheck(this.cm, tsaas).perform((Context)Mockito.mock(Context.class));
        Assert.assertEquals((Object)Status.Failure, (Object)response.getStatus());
        Assert.assertTrue((boolean)response.getMessage().contains(ConfigurationManager.ConfigStatus.FAILED.name()));
    }

    @Test
    public void shouldReturnStatusForInitSuccessful() throws Exception {
        Mockito.when((Object)this.cm.getStatus()).thenReturn((Object)ConfigurationManager.ConfigStatus.AUTHENTCATED);
        TsaasStorage tsaas = (TsaasStorage)Mockito.mock(TsaasStorage.class);
        Response response = new CloudHealthCheck(this.cm, tsaas).perform((Context)Mockito.mock(Context.class));
        Assert.assertEquals((Object)Status.Starting, (Object)response.getStatus());
        Assert.assertTrue((boolean)response.getMessage().contains(ConfigurationManager.ConfigStatus.AUTHENTCATED.name()));
    }
}

