/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.testserver;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;

public class GrpcTestServerInterceptor
implements ServerInterceptor {
    protected static final Context.Key<String> CLIENT_ID = Context.key((String)"clientID");
    private static final Metadata.Key<String> TOKEN = Metadata.Key.of((String)"token", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        String clientId = (String)metadata.get(TOKEN);
        if (clientId != null || !this.isTokenNeeded(serverCall.getMethodDescriptor().getFullMethodName())) {
            Context ctx = Context.current().withValue(CLIENT_ID, (Object)clientId);
            return Contexts.interceptCall((Context)ctx, serverCall, (Metadata)metadata, serverCallHandler);
        }
        Status status = Status.UNAUTHENTICATED.withDescription("Client token is missing or invalid");
        serverCall.close(status, metadata);
        return new ServerCall.Listener<ReqT>(){};
    }

    private boolean isTokenNeeded(String methodName) {
        return !"org.opennms.dataplatform.access.Authenticate/AuthenticateKey".equals(methodName) && !"org.opennms.dataplatform.access.Authenticate/GetServices".equals(methodName) && !"org.opennms.dataplatform.access.Authenticate/GetAccessToken".equals(methodName) && !"org.opennms.dataplatform.access.Authenticate/RenewCertificate".equals(methodName);
    }
}

