/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.integration.api.v1.distributed.KeyValueStore;
import org.opennms.plugins.cloud.config.ConfigStore;
import org.opennms.plugins.cloud.config.KvConfigStore;

public class KvConfigStoreTest {
    @Test
    public void shouldFailForNullStore() {
        Assert.assertThrows(NullPointerException.class, () -> new KvConfigStore(null));
    }

    @Test
    public void shouldRunCrud() {
        KvConfigStore store = new KvConfigStore((KeyValueStore)new InMemoryKvConfigStore());
        Assert.assertEquals(Optional.empty(), (Object)store.get(ConfigStore.Key.tokenvalue));
        Assert.assertNull((Object)store.getOrNull(ConfigStore.Key.tokenvalue));
        store.putProperty(ConfigStore.Key.tokenvalue, "value");
        Assert.assertEquals((Object)"value", store.get(ConfigStore.Key.tokenvalue).get());
        Assert.assertEquals((Object)"value", (Object)store.getOrNull(ConfigStore.Key.tokenvalue));
        store.putProperty(ConfigStore.Key.tokenvalue, "value2");
        Assert.assertEquals((Object)"value2", store.get(ConfigStore.Key.tokenvalue).get());
        Assert.assertEquals((Object)"value2", (Object)store.getOrNull(ConfigStore.Key.tokenvalue));
        HashMap<ConfigStore.Key, String> map = new HashMap<ConfigStore.Key, String>();
        map.put(ConfigStore.Key.tokenvalue, "value3");
        map.put(ConfigStore.Key.tokenkey, "key1");
        store.putProperties(map);
        Assert.assertEquals((Object)"value3", store.get(ConfigStore.Key.tokenvalue).get());
        Assert.assertEquals((Object)"value3", (Object)store.getOrNull(ConfigStore.Key.tokenvalue));
        Assert.assertEquals((Object)"key1", store.get(ConfigStore.Key.tokenkey).get());
        Assert.assertEquals((Object)"key1", (Object)store.getOrNull(ConfigStore.Key.tokenkey));
    }

    private static class InMemoryKvConfigStore
    implements KeyValueStore<String> {
        private Map<String, String> store = new HashMap<String, String>();

        private InMemoryKvConfigStore() {
        }

        public long put(String key, String value, String context) {
            Assert.assertEquals((Object)"plugin.cloud", (Object)context);
            this.store.put(key, value);
            return System.currentTimeMillis();
        }

        public long put(String key, String value, String context, Integer ttlInSeconds) {
            throw new UnsupportedOperationException("implement me");
        }

        public Optional<String> get(String key, String context) {
            Assert.assertEquals((Object)"plugin.cloud", (Object)context);
            return Optional.ofNullable(this.store.get(key));
        }

        public Optional<String> getIfStale(String key, String context, long timestamp) {
            throw new UnsupportedOperationException("implement me");
        }

        public OptionalLong getLastUpdated(String key, String context) {
            throw new UnsupportedOperationException("implement me");
        }

        public Map<String, String> enumerateContext(String context) {
            throw new UnsupportedOperationException("implement me");
        }

        public void delete(String key, String context) {
            throw new UnsupportedOperationException("implement me");
        }

        public void truncateContext(String context) {
            throw new UnsupportedOperationException("implement me");
        }

        public CompletableFuture<Long> putAsync(String key, String value, String context) {
            throw new UnsupportedOperationException("implement me");
        }

        public CompletableFuture<Long> putAsync(String key, String value, String context, Integer ttlInSeconds) {
            throw new UnsupportedOperationException("implement me");
        }

        public CompletableFuture<Optional<String>> getAsync(String key, String context) {
            throw new UnsupportedOperationException("implement me");
        }

        public CompletableFuture<Optional<String>> getIfStaleAsync(String key, String context, long timestamp) {
            throw new UnsupportedOperationException("implement me");
        }

        public CompletableFuture<OptionalLong> getLastUpdatedAsync(String key, String context) {
            throw new UnsupportedOperationException("implement me");
        }

        public String getName() {
            throw new UnsupportedOperationException("implement me");
        }

        public CompletableFuture<Map<String, String>> enumerateContextAsync(String context) {
            throw new UnsupportedOperationException("implement me");
        }

        public CompletableFuture<Void> deleteAsync(String key, String context) {
            throw new UnsupportedOperationException("implement me");
        }

        public CompletableFuture<Void> truncateContextAsync(String context) {
            throw new UnsupportedOperationException("implement me");
        }
    }
}

