/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.grpc;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.opennms.integration.api.v1.timeseries.StorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcExceptionHandler.class);
    private static final Set<Status.Code> RECOVERABLE_EXCEPTIONS = new HashSet<Status.Code>(Arrays.asList(Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE, Status.Code.UNAUTHENTICATED, Status.Code.RESOURCE_EXHAUSTED));

    private GrpcExceptionHandler() {
    }

    public static <T, R> R executeRpcCall(Supplier<T> callToExecute, Function<T, R> mapper, Supplier<R> defaultFunction) throws StorageException {
        try {
            T result = callToExecute.get();
            return mapper.apply(result);
        }
        catch (StatusRuntimeException ex) {
            Status.Code status = ex.getStatus().getCode();
            if (Status.Code.OK == status) {
                return defaultFunction.get();
            }
            if (RECOVERABLE_EXCEPTIONS.contains(status)) {
                throw new StorageException(String.format("Network problem %s", status), (Throwable)ex);
            }
            LOG.warn("An error happened during the RPC call: {}", (Object)status, (Object)ex);
            return defaultFunction.get();
        }
    }

    public static <T> void executeRpcCall(Supplier<T> callToExecute) throws StorageException {
        block3: {
            try {
                callToExecute.get();
            }
            catch (StatusRuntimeException ex) {
                Status.Code status = ex.getStatus().getCode();
                if (Status.Code.OK == status) break block3;
                if (RECOVERABLE_EXCEPTIONS.contains(status)) {
                    throw new StorageException(String.format("Network problem %s", status), (Throwable)ex);
                }
                LOG.warn("An error happened during the RPC call: {}", (Object)status, (Object)ex);
            }
        }
    }
}

