/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.config;

import io.grpc.BindableService;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.stub.AbstractBlockingStub;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.GrpcCleanupRule;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.opennms.dataplatform.access.AuthenticateGrpc;
import org.opennms.dataplatform.access.AuthenticateOuterClass;
import org.opennms.plugins.cloud.config.ConfigStore;
import org.opennms.plugins.cloud.config.PasAccess;
import org.opennms.plugins.cloud.grpc.GrpcConnection;
import org.opennms.plugins.cloud.srv.RegistrationManager;
import org.opennms.plugins.cloud.testserver.FileUtil;

public class PasAccessTest {
    @Rule
    public final GrpcCleanupRule grpcCleanup = new GrpcCleanupRule();

    @Test
    public void shouldConfigure() throws IOException {
        String serverHost = "myHost";
        int serverPort = 12345;
        final String privateKey = FileUtil.classpathFileToString("/cert/client_private_key.key");
        final String certificate = FileUtil.classpathFileToString("/cert/client_cert.crt");
        AuthenticateGrpc.AuthenticateImplBase authService = new AuthenticateGrpc.AuthenticateImplBase(){

            public void authenticateKey(AuthenticateOuterClass.AuthenticateKeyRequest request, StreamObserver<AuthenticateOuterClass.AuthenticateKeyResponse> responseObserver) {
                responseObserver.onNext((Object)AuthenticateOuterClass.AuthenticateKeyResponse.newBuilder().setGrpcEndpoint("myHost:12345").setPrivateKey(privateKey).setCertificate(certificate).build());
                responseObserver.onCompleted();
            }

            public void getServices(AuthenticateOuterClass.GetServicesRequest request, StreamObserver<AuthenticateOuterClass.GetServicesResponse> responseObserver) {
                responseObserver.onNext((Object)AuthenticateOuterClass.GetServicesResponse.newBuilder().putServices(RegistrationManager.Service.TSAAS.name(), AuthenticateOuterClass.Service.newBuilder().setEnabled(true).build()).putServices(RegistrationManager.Service.FAAS.name(), AuthenticateOuterClass.Service.newBuilder().setEnabled(false).build()).build());
                responseObserver.onCompleted();
            }

            public void getAccessToken(AuthenticateOuterClass.GetAccessTokenRequest request, StreamObserver<AuthenticateOuterClass.GetAccessTokenResponse> responseObserver) {
                responseObserver.onNext((Object)AuthenticateOuterClass.GetAccessTokenResponse.newBuilder().setToken("myToken").build());
                responseObserver.onCompleted();
            }

            public void renewCertificate(AuthenticateOuterClass.RenewCertificateRequest request, StreamObserver<AuthenticateOuterClass.RenewCertificateResponse> responseObserver) {
                responseObserver.onNext((Object)AuthenticateOuterClass.RenewCertificateResponse.newBuilder().setPrivateKey(privateKey).setCertificate(certificate).build());
                responseObserver.onCompleted();
            }
        };
        Server server = this.grpcCleanup.register(((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)PasAccessTest.class.getSimpleName()).directExecutor()).addService((BindableService)authService)).build().start());
        ManagedChannel channel = this.grpcCleanup.register(((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)PasAccessTest.class.getSimpleName()).directExecutor()).build());
        AuthenticateGrpc.AuthenticateBlockingStub stub = AuthenticateGrpc.newBlockingStub((Channel)channel);
        GrpcConnection grpc = new GrpcConnection((AbstractBlockingStub)stub, channel);
        PasAccess pas = new PasAccess(grpc);
        Map config = pas.getCredentialsFromAccessService("key", "systemId");
        Assert.assertEquals((Object)"myHost", config.get(ConfigStore.Key.grpchost));
        Assert.assertEquals((Object)Integer.toString(12345), config.get(ConfigStore.Key.grpcport));
        Assert.assertEquals((Object)privateKey, config.get(ConfigStore.Key.privatekey));
        Assert.assertEquals((Object)certificate, config.get(ConfigStore.Key.publickey));
        Assert.assertEquals(Set.of(RegistrationManager.Service.TSAAS), (Object)pas.getActiveServices("systemId"));
        Assert.assertEquals((Object)"myToken", (Object)pas.getToken(new HashSet(), "systemId"));
        Map newCerts = pas.renewCertificate("systemId");
        Assert.assertEquals((Object)privateKey, newCerts.get(ConfigStore.Key.privatekey));
        Assert.assertEquals((Object)certificate, newCerts.get(ConfigStore.Key.publickey));
        server.shutdown();
    }
}

