/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.testserver;

import java.io.IOException;
import java.util.Objects;
import lombok.Generated;
import org.junit.rules.ExternalResource;
import org.opennms.integration.api.v1.timeseries.InMemoryStorage;
import org.opennms.integration.api.v1.timeseries.TimeSeriesStorage;
import org.opennms.plugins.cloud.grpc.GrpcConnectionConfig;
import org.opennms.plugins.cloud.testserver.FileUtil;
import org.opennms.plugins.cloud.testserver.GrpcTestServer;

public class MockCloud
extends ExternalResource
implements AutoCloseable {
    private GrpcTestServer server;
    private final TimeSeriesStorage serverStorage;
    private GrpcConnectionConfig serverConfig;
    private GrpcConnectionConfig clientConfig;
    private final String certPrefix;
    private final String keyCertChainFilename;
    private final String keyFilename;

    public MockCloud(GrpcConnectionConfig serverConfig, TimeSeriesStorage serverStorage, String certPrefix, String keyCertChainFilename, String keyFilename) {
        this.serverConfig = serverConfig;
        this.serverStorage = Objects.requireNonNull(serverStorage);
        this.certPrefix = Objects.requireNonNull(certPrefix);
        this.keyCertChainFilename = Objects.requireNonNull(keyCertChainFilename);
        this.keyFilename = Objects.requireNonNull(keyFilename);
    }

    public static GrpcConnectionConfig.GrpcConnectionConfigBuilder defaultServerConfig() {
        return GrpcConnectionConfig.builder().port(0).security(GrpcConnectionConfig.Security.TLS);
    }

    public void start() throws IOException {
        this.server = new GrpcTestServer(this.serverConfig, this.serverStorage);
        this.server.startServer(this.certPrefix, this.keyCertChainFilename, this.keyFilename);
        this.clientConfig = this.server.getConfig().toBuilder().clientTrustStore(FileUtil.classpathFileToString(this.certPrefix + "/clienttruststore.pem")).build();
    }

    public GrpcConnectionConfig getClientConfigWithToken() {
        return this.getClientConfig().toBuilder().tokenValue("myAccessToken").build();
    }

    protected void before() throws IOException {
        this.start();
    }

    protected void after() {
        this.stop();
    }

    @Override
    public void close() {
        this.stop();
    }

    public void stop() {
        if (this.server != null) {
            this.server.stopServer();
        }
    }

    @Generated
    public static MockCloudBuilder builder() {
        return new MockCloudBuilder();
    }

    @Generated
    public TimeSeriesStorage getServerStorage() {
        return this.serverStorage;
    }

    @Generated
    public GrpcConnectionConfig getClientConfig() {
        return this.clientConfig;
    }

    public static class MockCloudBuilder {
        private GrpcConnectionConfig serverConfig = MockCloud.defaultServerConfig().build();
        private TimeSeriesStorage serverStorage = new InMemoryStorage();
        private String certPrefix = "/cert";
        private String keyFilename = "server_pkcs8_key.pem";
        private String keyCertChainFilename = "server.crt";

        @Generated
        MockCloudBuilder() {
        }

        @Generated
        public MockCloudBuilder serverConfig(GrpcConnectionConfig serverConfig) {
            this.serverConfig = serverConfig;
            return this;
        }

        @Generated
        public MockCloudBuilder serverStorage(TimeSeriesStorage serverStorage) {
            this.serverStorage = serverStorage;
            return this;
        }

        @Generated
        public MockCloudBuilder certPrefix(String certPrefix) {
            this.certPrefix = certPrefix;
            return this;
        }

        @Generated
        public MockCloudBuilder keyCertChainFilename(String keyCertChainFilename) {
            this.keyCertChainFilename = keyCertChainFilename;
            return this;
        }

        @Generated
        public MockCloudBuilder keyFilename(String keyFilename) {
            this.keyFilename = keyFilename;
            return this;
        }

        @Generated
        public MockCloud build() {
            return new MockCloud(this.serverConfig, this.serverStorage, this.certPrefix, this.keyCertChainFilename, this.keyFilename);
        }

        @Generated
        public String toString() {
            return "MockCloud.MockCloudBuilder(serverConfig=" + this.serverConfig + ", serverStorage=" + this.serverStorage + ", certPrefix=" + this.certPrefix + ", keyCertChainFilename=" + this.keyCertChainFilename + ", keyFilename=" + this.keyFilename + ")";
        }
    }
}

