/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.testserver;

import com.google.protobuf.Empty;
import io.grpc.BindableService;
import io.grpc.stub.StreamObserver;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.StorageException;
import org.opennms.integration.api.v1.timeseries.TimeSeriesData;
import org.opennms.integration.api.v1.timeseries.TimeSeriesFetchRequest;
import org.opennms.integration.api.v1.timeseries.TimeSeriesStorage;
import org.opennms.plugins.cloud.srv.tsaas.grpc.GrpcObjectMapper;
import org.opennms.plugins.cloud.testserver.GrpcTestServerInterceptor;
import org.opennms.tsaas.TimeseriesGrpc;
import org.opennms.tsaas.Tsaas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsaasGrpcImpl
extends TimeseriesGrpc.TimeseriesImplBase
implements BindableService {
    private static final Logger LOG = LoggerFactory.getLogger(TsaasGrpcImpl.class);
    private final TimeSeriesStorage storage;

    public TsaasGrpcImpl(TimeSeriesStorage storage) {
        this.storage = Objects.requireNonNull(storage);
    }

    public void store(Tsaas.Samples request, StreamObserver<Empty> responseObserver) {
        LOG.debug("Store endpoint received {} samples with clientID {}", (Object)request.getSamplesCount(), GrpcTestServerInterceptor.CLIENT_ID.get());
        List samples = request.getSamplesList().stream().map(GrpcObjectMapper::toSample).collect(Collectors.toList());
        try {
            this.storage.store(samples);
            responseObserver.onNext((Object)Empty.getDefaultInstance());
            responseObserver.onCompleted();
            LOG.debug("Successfully wrote {} samples.", (Object)request.getSamplesCount());
        }
        catch (StorageException e) {
            LOG.error("Failed to write {} samples.", (Object)request.getSamplesCount(), (Object)e);
            responseObserver.onError((Throwable)e);
        }
    }

    public void findMetrics(Tsaas.TagMatchers request, StreamObserver<Tsaas.Metrics> responseObserver) {
        LOG.debug("findMetrics called with client ID {}", GrpcTestServerInterceptor.CLIENT_ID.get());
        Collection tagMatchers = request.getMatchersList().stream().map(GrpcObjectMapper::toTagMatcher).collect(Collectors.toList());
        try {
            List metrics = this.storage.findMetrics(tagMatchers);
            Tsaas.Metrics grpcMetrics = GrpcObjectMapper.toMetrics((List)metrics);
            responseObserver.onNext((Object)grpcMetrics);
            responseObserver.onCompleted();
            LOG.debug("Found {} metrics.", (Object)grpcMetrics.getMetricsCount());
        }
        catch (StorageException e) {
            LOG.error("Failed to query metrics.", (Throwable)e);
            responseObserver.onError((Throwable)e);
        }
    }

    public void getTimeseriesData(Tsaas.FetchRequest request, StreamObserver<Tsaas.TimeseriesData> responseObserver) {
        LOG.debug("getTimeseries called with client ID {}", GrpcTestServerInterceptor.CLIENT_ID.get());
        TimeSeriesFetchRequest fetchRequest = GrpcObjectMapper.toTimeseriesFetchRequest((Tsaas.FetchRequest)request);
        try {
            TimeSeriesData timeSeriesData = this.storage.getTimeSeriesData(fetchRequest);
            List dataPoints = timeSeriesData.getDataPoints().stream().map(GrpcObjectMapper::toDataPoint).collect(Collectors.toList());
            Tsaas.TimeseriesData timeseriesData = Tsaas.TimeseriesData.newBuilder().addAllDataPoints(dataPoints).setMetric(GrpcObjectMapper.toMetric((Metric)timeSeriesData.getMetric())).build();
            responseObserver.onNext((Object)timeseriesData);
            responseObserver.onCompleted();
            LOG.debug("Successfully queried timeseries - found {} samples.", (Object)timeSeriesData.getDataPoints().size());
        }
        catch (StorageException e) {
            LOG.error("Failed to retrieve timeseries.", (Throwable)e);
            responseObserver.onError((Throwable)e);
        }
    }

    public void checkHealth(Tsaas.CheckHealthRequest request, StreamObserver<Tsaas.CheckHealthResponse> responseObserver) {
        Tsaas.CheckHealthResponse response = Tsaas.CheckHealthResponse.newBuilder().setStatus(Tsaas.CheckHealthResponse.ServingStatus.SERVING).build();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void shutdown() {
    }
}

