/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.srv.tsaas.grpc;

import com.google.protobuf.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.timeseries.Aggregation;
import org.opennms.integration.api.v1.timeseries.DataPoint;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.Sample;
import org.opennms.integration.api.v1.timeseries.Tag;
import org.opennms.integration.api.v1.timeseries.TagMatcher;
import org.opennms.integration.api.v1.timeseries.TimeSeriesFetchRequest;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableMetric;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableSample;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableTag;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableTagMatcher;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableTimeSeriesFetchRequest;
import org.opennms.tsaas.Tsaas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcObjectMapper {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcObjectMapper.class);

    private GrpcObjectMapper() {
    }

    public static Tsaas.Tag toTag(Tag tag) {
        return Tsaas.Tag.newBuilder().setKey(tag.getKey()).setValue(tag.getValue()).build();
    }

    public static Tag toTag(Tsaas.Tag tag) {
        return new ImmutableTag(tag.getKey(), tag.getValue());
    }

    public static Tsaas.TagMatcher toTagMatcher(TagMatcher tagMatcher) {
        return Tsaas.TagMatcher.newBuilder().setType(GrpcObjectMapper.toTagMatcherType(tagMatcher.getType())).setKey(tagMatcher.getKey()).setValue(tagMatcher.getValue()).build();
    }

    public static TagMatcher toTagMatcher(Tsaas.TagMatcher tagMatcher) {
        return ImmutableTagMatcher.builder().type(GrpcObjectMapper.toTagMatcherType(tagMatcher.getType())).key(tagMatcher.getKey()).value(tagMatcher.getValue()).build();
    }

    public static Tsaas.Metric toMetric(Metric metric) {
        return Tsaas.Metric.newBuilder().setKey(metric.getKey()).addAllIntrinsicTags((Iterable)metric.getIntrinsicTags().stream().map(GrpcObjectMapper::toTag).collect(Collectors.toSet())).addAllMetaTags((Iterable)metric.getMetaTags().stream().map(GrpcObjectMapper::toTag).collect(Collectors.toSet())).addAllExternalTags((Iterable)metric.getExternalTags().stream().map(GrpcObjectMapper::toTag).collect(Collectors.toSet())).build();
    }

    public static Metric toMetric(Tsaas.Metric metric) {
        ImmutableMetric.MetricBuilder builder = ImmutableMetric.builder();
        metric.getIntrinsicTagsList().stream().map(GrpcObjectMapper::toTag).forEach(arg_0 -> ((ImmutableMetric.MetricBuilder)builder).intrinsicTag(arg_0));
        metric.getMetaTagsList().stream().map(GrpcObjectMapper::toTag).forEach(arg_0 -> ((ImmutableMetric.MetricBuilder)builder).metaTag(arg_0));
        metric.getExternalTagsList().stream().map(GrpcObjectMapper::toTag).forEach(arg_0 -> ((ImmutableMetric.MetricBuilder)builder).externalTag(arg_0));
        return builder.build();
    }

    public static boolean isValid(Metric metric) {
        if (metric.getFirstTagByKey("mtype") == null) {
            LOG.warn("tag mtype is missing in metric, will ignore it: {}", (Object)metric);
            return false;
        }
        if (metric.getFirstTagByKey("resourceId") == null) {
            LOG.warn("tag resourceId is missing in metric, will ignore it: {}", (Object)metric);
            return false;
        }
        if (metric.getFirstTagByKey("name") == null) {
            LOG.warn("tag name is missing in metric, will ignore it: {}", (Object)metric);
            return false;
        }
        return true;
    }

    public static Tsaas.Metrics toMetrics(List<Metric> metrics) {
        List grpcMetrics = metrics.stream().map(GrpcObjectMapper::toMetric).collect(Collectors.toList());
        return Tsaas.Metrics.newBuilder().addAllMetrics(grpcMetrics).build();
    }

    public static List<Metric> toMetrics(Tsaas.Metrics metrics) {
        return metrics.getMetricsList().stream().map(GrpcObjectMapper::toMetric).filter(GrpcObjectMapper::isValid).collect(Collectors.toList());
    }

    public static Tsaas.Sample toSample(Sample sample) {
        return Tsaas.Sample.newBuilder().setMetric(GrpcObjectMapper.toMetric(sample.getMetric())).setTime(GrpcObjectMapper.toTimestamp(sample.getTime())).setValue(sample.getValue().doubleValue()).build();
    }

    public static Sample toSample(Tsaas.Sample sample) {
        return ImmutableSample.builder().metric(GrpcObjectMapper.toMetric(sample.getMetric())).time(GrpcObjectMapper.toTimestamp(sample.getTime())).value(Double.valueOf(sample.getValue())).build();
    }

    public static Sample toSample(Metric metric, Tsaas.DataPoint dataPoint) {
        return ImmutableSample.builder().metric(metric).time(GrpcObjectMapper.toTimestamp(dataPoint.getTime())).value(Double.valueOf(dataPoint.getValue())).build();
    }

    public static Tsaas.DataPoint toDataPoint(DataPoint dataPoint) {
        return Tsaas.DataPoint.newBuilder().setTime(GrpcObjectMapper.toTimestamp(dataPoint.getTime())).setValue(dataPoint.getValue().doubleValue()).build();
    }

    public static List<Sample> toSamples(Tsaas.TimeseriesData timeseriesData) {
        Metric metric = GrpcObjectMapper.toMetric(timeseriesData.getMetric());
        if (!GrpcObjectMapper.isValid(metric)) {
            return Collections.emptyList();
        }
        return timeseriesData.getDataPointsList().stream().map(d -> GrpcObjectMapper.toSample(metric, d)).collect(Collectors.toList());
    }

    public static Timestamp toTimestamp(Instant instant) {
        return Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
    }

    public static Instant toTimestamp(Timestamp timestamp) {
        return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
    }

    public static TimeSeriesFetchRequest toTimeseriesFetchRequest(Tsaas.FetchRequest request) {
        return ImmutableTimeSeriesFetchRequest.builder().aggregation(GrpcObjectMapper.toAggregation(request.getAggregation())).metric(GrpcObjectMapper.toMetric(request.getMetric())).end(GrpcObjectMapper.toTimestamp(request.getEnd())).start(GrpcObjectMapper.toTimestamp(request.getStart())).step(GrpcObjectMapper.toStep(request.getStep())).build();
    }

    private static Duration toStep(long step) {
        return Duration.ofMillis(step);
    }

    private static Aggregation toAggregation(Tsaas.Aggregation aggregation) {
        if (aggregation == Tsaas.Aggregation.AVERAGE) {
            return Aggregation.AVERAGE;
        }
        if (aggregation == Tsaas.Aggregation.MAX) {
            return Aggregation.MAX;
        }
        if (aggregation == Tsaas.Aggregation.MIN) {
            return Aggregation.MIN;
        }
        if (aggregation == Tsaas.Aggregation.NONE) {
            return Aggregation.NONE;
        }
        return Aggregation.NONE;
    }

    private static TagMatcher.Type toTagMatcherType(Tsaas.TagMatcherType type) {
        if (type == Tsaas.TagMatcherType.EQUALS) {
            return TagMatcher.Type.EQUALS;
        }
        if (type == Tsaas.TagMatcherType.NOT_EQUALS) {
            return TagMatcher.Type.NOT_EQUALS;
        }
        if (type == Tsaas.TagMatcherType.EQUALS_REGEX) {
            return TagMatcher.Type.EQUALS_REGEX;
        }
        if (type == Tsaas.TagMatcherType.NOT_EQUALS_REGEX) {
            return TagMatcher.Type.NOT_EQUALS_REGEX;
        }
        throw new IllegalArgumentException("Unknown Tsaas.TagMatcherType: " + type);
    }

    private static Tsaas.TagMatcherType toTagMatcherType(TagMatcher.Type type) {
        if (type == TagMatcher.Type.EQUALS) {
            return Tsaas.TagMatcherType.EQUALS;
        }
        if (type == TagMatcher.Type.NOT_EQUALS) {
            return Tsaas.TagMatcherType.NOT_EQUALS;
        }
        if (type == TagMatcher.Type.EQUALS_REGEX) {
            return Tsaas.TagMatcherType.EQUALS_REGEX;
        }
        if (type == TagMatcher.Type.NOT_EQUALS_REGEX) {
            return Tsaas.TagMatcherType.NOT_EQUALS_REGEX;
        }
        throw new IllegalArgumentException("Unknown TagMatcher.Type: " + type);
    }
}

