/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.srv.tsaas;

import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opennms.integration.api.v1.timeseries.Aggregation;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.Sample;
import org.opennms.integration.api.v1.timeseries.StorageException;
import org.opennms.integration.api.v1.timeseries.TagMatcher;
import org.opennms.integration.api.v1.timeseries.TimeSeriesFetchRequest;
import org.opennms.integration.api.v1.timeseries.TimeSeriesStorage;
import org.opennms.plugins.cloud.grpc.CloseUtil;
import org.opennms.plugins.cloud.grpc.GrpcConnection;
import org.opennms.plugins.cloud.grpc.GrpcConnectionConfig;
import org.opennms.plugins.cloud.grpc.GrpcExceptionHandler;
import org.opennms.plugins.cloud.srv.GrpcService;
import org.opennms.plugins.cloud.srv.tsaas.TsaasConfig;
import org.opennms.plugins.cloud.srv.tsaas.grpc.GrpcObjectMapper;
import org.opennms.tsaas.TimeseriesGrpc;
import org.opennms.tsaas.Tsaas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsaasStorage
implements TimeSeriesStorage,
GrpcService {
    private static final Logger LOG = LoggerFactory.getLogger(TsaasStorage.class);
    private final TsaasConfig config;
    private final ConcurrentLinkedDeque<Tsaas.Sample> queue;
    private Instant lastBatchSentTs;
    @VisibleForTesting
    private GrpcConnection<TimeseriesGrpc.TimeseriesBlockingStub> grpc;

    public TsaasStorage(TsaasConfig config) {
        this.config = Objects.requireNonNull(config);
        this.queue = new ConcurrentLinkedDeque();
        this.lastBatchSentTs = Instant.now();
    }

    @Override
    public void initGrpc(GrpcConnectionConfig grpcConfig) {
        GrpcConnection<TimeseriesGrpc.TimeseriesBlockingStub> oldGrpc = this.grpc;
        LOG.debug("Initializing Grpc Connection with host {} and port {}", (Object)grpcConfig.getHost(), (Object)grpcConfig.getPort());
        this.grpc = new GrpcConnection<TimeseriesGrpc.TimeseriesBlockingStub>(grpcConfig, TimeseriesGrpc::newBlockingStub);
        CloseUtil.close(oldGrpc);
    }

    public void store(List<Sample> samples) throws StorageException {
        samples.stream().map(GrpcObjectMapper::toSample).forEach(this.queue::add);
        while (this.queue.size() >= this.config.getBatchSize() || !this.queue.isEmpty() && this.lastBatchSentTs.plusMillis(this.config.getMaxBatchWaitTimeInMilliSeconds()).isBefore(Instant.now())) {
            Tsaas.Sample next;
            Tsaas.Samples.Builder builder = Tsaas.Samples.newBuilder();
            for (int i = 0; i < this.config.getBatchSize() && (next = this.queue.poll()) != null; ++i) {
                builder.addSamples(next);
            }
            if (builder.getSamplesCount() <= 0) continue;
            GrpcExceptionHandler.executeRpcCall(() -> this.grpc.get().store(builder.build()));
            this.lastBatchSentTs = Instant.now();
        }
    }

    public List<Metric> findMetrics(Collection<TagMatcher> tagMatchers) throws StorageException {
        Objects.requireNonNull(tagMatchers);
        if (tagMatchers.isEmpty()) {
            throw new IllegalArgumentException("at least one TagMatcher is required.");
        }
        List mappedTags = tagMatchers.stream().map(GrpcObjectMapper::toTagMatcher).collect(Collectors.toList());
        Tsaas.TagMatchers tagsMessage = Tsaas.TagMatchers.newBuilder().addAllMatchers(mappedTags).build();
        LOG.trace("Getting the metrics for the following tags: {}", (Object)tagsMessage);
        return GrpcExceptionHandler.executeRpcCall(() -> this.grpc.get().findMetrics(tagsMessage), GrpcObjectMapper::toMetrics, Collections::emptyList);
    }

    public List<Sample> getTimeseries(TimeSeriesFetchRequest request) throws StorageException {
        Objects.requireNonNull(request.getMetric());
        Tsaas.FetchRequest fetchRequest = Tsaas.FetchRequest.newBuilder().setMetric(GrpcObjectMapper.toMetric(request.getMetric())).setStart(GrpcObjectMapper.toTimestamp(request.getStart())).setEnd(GrpcObjectMapper.toTimestamp(request.getEnd())).setStep(request.getStep().getSeconds()).setAggregation(Tsaas.Aggregation.valueOf((String)request.getAggregation().name())).build();
        LOG.trace("Getting time series for request: {}", (Object)fetchRequest);
        return GrpcExceptionHandler.executeRpcCall(() -> this.grpc.get().getTimeseriesData(fetchRequest), GrpcObjectMapper::toSamples, Collections::emptyList);
    }

    public void delete(Metric metric) {
        LOG.warn("Attempted to delete metric {} but deleting is unsupported", (Object)metric);
        throw new UnsupportedOperationException("Deleting is not currently supported");
    }

    public boolean supportsAggregation(Aggregation aggregation) {
        return false;
    }

    public Tsaas.CheckHealthResponse checkHealth() {
        return this.grpc.get().checkHealth(Tsaas.CheckHealthRequest.newBuilder().build());
    }

    @Override
    public void destroy() {
        CloseUtil.close(this.grpc);
    }

    @Generated
    public GrpcConnection<TimeseriesGrpc.TimeseriesBlockingStub> getGrpc() {
        return this.grpc;
    }
}

