/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.srv.tsaas.shell;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.TagMatcher;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableTagMatcher;
import org.opennms.plugins.cloud.srv.tsaas.TsaasStorage;

@Command(scope="opennms-tsaas", name="query-metrics", description="Find metrics.", detailedDescription="pairs")
@Service
public class MetricQuery
implements Action {
    @Reference
    TsaasStorage tss;
    @Argument(multiValued=true)
    List<String> arguments = new LinkedList<String>();

    public Object execute() throws Exception {
        List<TagMatcher> tagMatchers = MetricQuery.toTagMatchers(this.arguments);
        System.out.println("Querying metrics for tags: " + tagMatchers);
        List<Metric> metrics = this.tss.findMetrics(tagMatchers);
        System.out.println("Metrics:");
        for (Metric metric : metrics) {
            System.out.println("\t" + metric);
        }
        if (metrics.isEmpty()) {
            System.out.println("(No results returned)");
        }
        return null;
    }

    public static List<TagMatcher> toTagMatchers(Collection<String> s) {
        if (s.size() % 2 == 1) {
            throw new IllegalArgumentException("collection must have an even number of arguments");
        }
        AtomicInteger counter = new AtomicInteger(0);
        return s.stream().collect(Collectors.groupingBy(el -> {
            int i = counter.getAndIncrement();
            return i % 2 == 0 ? i : i - 1;
        })).values().stream().map(a -> ImmutableTagMatcher.builder().key((String)a.get(0)).value(a.size() == 2 ? (String)a.get(1) : null).build()).collect(Collectors.toList());
    }
}

