/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.config;

import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opennms.integration.api.v1.runtime.RuntimeInfo;
import org.opennms.plugins.cloud.config.ConfigStore;
import org.opennms.plugins.cloud.config.ConfigurationManager;
import org.opennms.plugins.cloud.config.InMemoryConfigStore;
import org.opennms.plugins.cloud.grpc.GrpcConnectionConfig;
import org.opennms.plugins.cloud.srv.GrpcService;
import org.opennms.plugins.cloud.srv.RegistrationManager;
import org.opennms.plugins.cloud.srv.faas.Faas;
import org.opennms.plugins.cloud.srv.tsaas.TsaasConfig;
import org.opennms.plugins.cloud.srv.tsaas.TsaasStorage;
import org.opennms.plugins.cloud.testserver.FileUtil;
import org.opennms.plugins.cloud.testserver.MockCloud;
import org.opennms.tsaas.Tsaas;

public class ConfigurationManagerTest {
    @ClassRule
    public static MockCloud cloud = MockCloud.builder().build();
    private ConfigStore config;
    private GrpcService grpc;
    private RuntimeInfo info;
    private GrpcConnectionConfig clientConfig;

    @Before
    public void setUp() throws IOException {
        this.config = new InMemoryConfigStore();
        this.grpc = (GrpcService)Mockito.mock(GrpcService.class);
        this.info = (RuntimeInfo)Mockito.mock(RuntimeInfo.class);
        Mockito.when((Object)this.info.getSystemId()).thenReturn((Object)UUID.randomUUID().toString());
        this.clientConfig = cloud.getClientConfig();
    }

    @Test
    public void shouldGetCloudConfig() {
        TsaasStorage grpc = (TsaasStorage)Mockito.spy((Object)new TsaasStorage(new TsaasConfig(1, 1L)));
        ConfigurationManager cm = new ConfigurationManager(this.config, this.clientConfig, this.clientConfig, (RegistrationManager)Mockito.mock(RegistrationManager.class), this.info, Collections.singletonList(grpc));
        Assert.assertEquals((Object)ConfigurationManager.ConfigStatus.NOT_ATTEMPTED, (Object)cm.getStatus());
        cm.initConfiguration("something");
        Assert.assertEquals((Object)ConfigurationManager.ConfigStatus.AUTHENTCATED, (Object)cm.getStatus());
        this.config.putProperty(ConfigStore.Key.truststore, FileUtil.classpathFileToString("/cert/clienttruststore.pem"));
        cm.configure();
        Assert.assertEquals((Object)ConfigurationManager.ConfigStatus.CONFIGURED, (Object)cm.getStatus());
        ((TsaasStorage)Mockito.verify((Object)grpc, (VerificationMode)Mockito.times((int)1))).initGrpc((GrpcConnectionConfig)ArgumentMatchers.any());
        Assert.assertTrue((boolean)this.config.getOrNull(ConfigStore.Key.privatekey).startsWith("-----BEGIN PRIVATE KEY-----"));
        Assert.assertTrue((boolean)this.config.getOrNull(ConfigStore.Key.publickey).startsWith("-----BEGIN CERTIFICATE-----"));
        cm.checkConnection();
    }

    @Test
    public void shouldSetStatusForFailedConfig() {
        ConfigurationManager cm = new ConfigurationManager(this.config, this.clientConfig, this.clientConfig, (RegistrationManager)Mockito.mock(RegistrationManager.class), this.info, Collections.singletonList(this.grpc));
        String key = null;
        Assert.assertThrows(NullPointerException.class, () -> cm.initConfiguration(key));
        Assert.assertEquals((Object)ConfigurationManager.ConfigStatus.FAILED, (Object)cm.getStatus());
    }

    @Test
    public void shouldSetStatusForFailedInit() throws InterruptedException {
        ConfigurationManager cm = new ConfigurationManager(this.config, this.clientConfig, this.clientConfig, (RegistrationManager)Mockito.mock(RegistrationManager.class), this.info, Collections.singletonList(this.grpc));
        cm.initConfiguration("something");
        this.config.putProperty(ConfigStore.Key.grpchost, "I don't exist");
        Assert.assertEquals((Object)ConfigurationManager.ConfigStatus.FAILED, (Object)cm.configure());
    }

    @Test
    public void shouldCatchAllErrorsFromGrpcInit() {
        ((GrpcService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("failed")}).when((Object)this.grpc)).initGrpc((GrpcConnectionConfig)ArgumentMatchers.any(GrpcConnectionConfig.class));
        ConfigurationManager cm = new ConfigurationManager(this.config, this.clientConfig, this.clientConfig, (RegistrationManager)Mockito.mock(RegistrationManager.class), this.info, Collections.singletonList(this.grpc));
        cm.initGrpcServices(GrpcConnectionConfig.builder().build());
    }

    @Test
    public void shouldRenewCredentials() throws Exception {
        TsaasStorage grpc = (TsaasStorage)Mockito.mock(TsaasStorage.class);
        Mockito.when((Object)grpc.checkHealth()).thenReturn((Object)Tsaas.CheckHealthResponse.newBuilder().setStatus(Tsaas.CheckHealthResponse.ServingStatus.SERVING).build());
        ConfigurationManager cm = new ConfigurationManager(this.config, this.clientConfig, this.clientConfig, (RegistrationManager)Mockito.mock(RegistrationManager.class), this.info, Collections.singletonList(grpc));
        Assert.assertEquals((Object)ConfigurationManager.ConfigStatus.NOT_ATTEMPTED, (Object)cm.getStatus());
        cm.initConfiguration("something");
        Assert.assertEquals((Object)ConfigurationManager.ConfigStatus.AUTHENTCATED, (Object)cm.getStatus());
        cm.configure();
        Assert.assertEquals((Object)ConfigurationManager.ConfigStatus.CONFIGURED, (Object)cm.getStatus());
        ((TsaasStorage)Mockito.verify((Object)grpc, (VerificationMode)Mockito.times((int)1))).initGrpc((GrpcConnectionConfig)ArgumentMatchers.any());
        cm.renewCerts();
        Assert.assertTrue((boolean)this.config.getOrNull(ConfigStore.Key.privatekey).startsWith("-----BEGIN PRIVATE KEY-----"));
        Assert.assertTrue((boolean)this.config.getOrNull(ConfigStore.Key.publickey).startsWith("-----BEGIN CERTIFICATE-----"));
        Assert.assertEquals((Object)ConfigurationManager.ConfigStatus.CONFIGURED, (Object)cm.getStatus());
    }

    @Test
    public void shouldRenewCredentialsFail() {
        TsaasStorage grpc = (TsaasStorage)Mockito.mock(TsaasStorage.class);
        Mockito.when((Object)grpc.checkHealth()).thenReturn((Object)Tsaas.CheckHealthResponse.newBuilder().setStatus(Tsaas.CheckHealthResponse.ServingStatus.SERVING).build());
        ConfigurationManager cm = new ConfigurationManager(this.config, this.clientConfig, this.clientConfig, (RegistrationManager)Mockito.mock(RegistrationManager.class), this.info, Collections.singletonList(grpc));
        Assert.assertThrows(NullPointerException.class, () -> ((ConfigurationManager)cm).renewCerts());
        Assert.assertEquals((Object)ConfigurationManager.ConfigStatus.FAILED, (Object)cm.getStatus());
    }

    @Test
    public void shouldCallConfigureIfAuthenticatedOrConfigured() {
        TsaasStorage grpc = (TsaasStorage)Mockito.spy((Object)new TsaasStorage(new TsaasConfig(1, 1L)));
        ConfigurationManager cm = new ConfigurationManager(this.config, this.clientConfig, this.clientConfig, (RegistrationManager)Mockito.mock(RegistrationManager.class), this.info, Collections.singletonList(grpc));
        cm.initConfiguration("something");
        Assert.assertEquals((Object)ConfigurationManager.ConfigStatus.AUTHENTCATED, (Object)cm.getStatus());
        this.config.putProperty(ConfigStore.Key.truststore, FileUtil.classpathFileToString("/cert/clienttruststore.pem"));
        cm = new ConfigurationManager(this.config, this.clientConfig, this.clientConfig, (RegistrationManager)Mockito.mock(RegistrationManager.class), this.info, Collections.singletonList(grpc));
        Assert.assertEquals((Object)ConfigurationManager.ConfigStatus.CONFIGURED, (Object)cm.getStatus());
        ((TsaasStorage)Mockito.verify((Object)grpc, (VerificationMode)Mockito.times((int)1))).initGrpc((GrpcConnectionConfig)ArgumentMatchers.any());
        Mockito.clearInvocations((Object[])new TsaasStorage[]{grpc});
        cm = new ConfigurationManager(this.config, this.clientConfig, this.clientConfig, (RegistrationManager)Mockito.mock(RegistrationManager.class), this.info, Collections.singletonList(grpc));
        Assert.assertEquals((Object)ConfigurationManager.ConfigStatus.CONFIGURED, (Object)cm.getStatus());
        ((TsaasStorage)Mockito.verify((Object)grpc, (VerificationMode)Mockito.times((int)1))).initGrpc((GrpcConnectionConfig)ArgumentMatchers.any());
    }

    @Test
    public void shouldAbleToDeactivate() {
        TsaasStorage grpc = (TsaasStorage)Mockito.spy((Object)new TsaasStorage(new TsaasConfig(1, 1L)));
        Faas faas = (Faas)Mockito.spy((Object)new Faas());
        List<GrpcService> serviceList = Arrays.asList(grpc, faas);
        ConfigurationManager cm = new ConfigurationManager(this.config, this.clientConfig, this.clientConfig, (RegistrationManager)Mockito.mock(RegistrationManager.class), this.info, serviceList);
        cm.initConfiguration("something");
        cm.configure();
        cm.checkConnection();
        cm.deactivateKeyConfiguration();
        Assert.assertEquals((Object)ConfigurationManager.ConfigStatus.DEACTIVATED, (Object)cm.getStatus());
        Assert.assertThrows(StatusRuntimeException.class, () -> cm.checkConnection());
    }
}

