/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.srv.tsaas;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.Sample;
import org.opennms.integration.api.v1.timeseries.StorageException;
import org.opennms.integration.api.v1.timeseries.TimeSeriesStorage;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableMetric;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableSample;
import org.opennms.plugins.cloud.srv.tsaas.TsaasConfig;
import org.opennms.plugins.cloud.srv.tsaas.TsaasStorage;
import org.opennms.plugins.cloud.testserver.MockCloud;

public class TsaasStorageNetworkProblemTest {
    @Rule
    public MockCloud cloud = MockCloud.builder().serverStorage((TimeSeriesStorage)Mockito.mock(TimeSeriesStorage.class)).build();

    @Test
    public void shouldRecoverAfterServerFailure() throws StorageException, InterruptedException, IOException {
        TsaasStorage plugin = new TsaasStorage(TsaasConfig.builder().batchSize(1).build());
        plugin.initGrpc(this.cloud.getClientConfigWithToken());
        plugin.store(this.createSamples());
        ((TimeSeriesStorage)Mockito.verify((Object)this.cloud.getServerStorage(), (VerificationMode)Mockito.times((int)1))).store((List)ArgumentMatchers.any());
        Mockito.reset((Object[])new TimeSeriesStorage[]{this.cloud.getServerStorage()});
        this.cloud.stop();
        Assert.assertThrows(StorageException.class, () -> plugin.store(this.createSamples()));
        ((TimeSeriesStorage)Mockito.verify((Object)this.cloud.getServerStorage(), (VerificationMode)Mockito.never())).store((List)ArgumentMatchers.any());
        this.cloud = MockCloud.builder().serverConfig(this.cloud.getClientConfigWithToken()).serverStorage((TimeSeriesStorage)Mockito.mock(TimeSeriesStorage.class)).build();
        this.cloud.start();
        plugin.getGrpc().managedChannel.resetConnectBackoff();
        plugin.store(this.createSamples());
        ((TimeSeriesStorage)Mockito.verify((Object)this.cloud.getServerStorage(), (VerificationMode)Mockito.times((int)1))).store((List)ArgumentMatchers.any());
    }

    @Test
    public void shouldRecoverAfterServerException() throws StorageException, InterruptedException {
        TsaasStorage plugin = new TsaasStorage(TsaasConfig.builder().batchSize(1).build());
        plugin.initGrpc(this.cloud.getClientConfigWithToken());
        ((TimeSeriesStorage)Mockito.doThrow((Throwable[])new Throwable[]{new StorageException("hups")}).when((Object)this.cloud.getServerStorage())).store((List)ArgumentMatchers.any());
        plugin.store(this.createSamples());
        ((TimeSeriesStorage)Mockito.doNothing().when((Object)this.cloud.getServerStorage())).store((List)ArgumentMatchers.any());
        plugin.store(this.createSamples());
        ((TimeSeriesStorage)Mockito.verify((Object)this.cloud.getServerStorage(), (VerificationMode)Mockito.times((int)2))).store((List)ArgumentMatchers.any());
    }

    private List<Sample> createSamples() {
        return Collections.singletonList(ImmutableSample.builder().time(Instant.now()).metric((Metric)ImmutableMetric.builder().intrinsicTag("resourceId", "a").intrinsicTag("name", "b").build()).value(Double.valueOf(3.0)).build());
    }

    @After
    public void shutDown() {
        this.cloud.stop();
    }
}

