/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.srv.tsaas;

import java.util.HashMap;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.opennms.integration.api.v1.timeseries.AbstractStorageIntegrationTest;
import org.opennms.integration.api.v1.timeseries.TimeSeriesStorage;
import org.opennms.plugins.cloud.grpc.GrpcConnectionConfig;
import org.opennms.plugins.cloud.srv.tsaas.TsaasConfig;
import org.opennms.plugins.cloud.srv.tsaas.TsaasStorage;
import org.opennms.plugins.cloud.testserver.FileUtil;
import org.opennms.plugins.cloud.testserver.MockCloud;

public class TsaasStorageWithMtlsTest
extends AbstractStorageIntegrationTest {
    private TsaasStorage storage;
    @Rule
    public final MockCloud cloud = MockCloud.builder().serverConfig(MockCloud.defaultServerConfig().security(GrpcConnectionConfig.Security.MTLS).build()).build();

    @Before
    public void setUp() throws Exception {
        GrpcConnectionConfig.GrpcConnectionConfigBuilder clientConfig = this.cloud.getClientConfigWithToken().toBuilder();
        HashMap attributes = new HashMap();
        clientConfig.publicKey(FileUtil.classpathFileToString("/cert/client_cert.crt"));
        clientConfig.privateKey(FileUtil.classpathFileToString("/cert/client_private_key.key"));
        clientConfig.clientTrustStore(FileUtil.classpathFileToString("/cert/clienttruststore.pem"));
        TsaasConfig tsaasConfig = TsaasConfig.builder().batchSize(1).build();
        this.storage = new TsaasStorage(tsaasConfig);
        this.storage.initGrpc(clientConfig.build());
        super.setUp();
    }

    @After
    public void tearDown() throws InterruptedException {
        if (this.storage != null) {
            this.storage.destroy();
        }
    }

    protected TimeSeriesStorage createStorage() throws Exception {
        return this.storage;
    }

    @Test
    @Ignore(value="we don't implement delete(), hence @Ignore")
    public void shouldDeleteMetrics() throws Exception {
    }
}

