/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.config;

import java.security.cert.CertificateException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.opennms.integration.api.v1.runtime.Container;
import org.opennms.integration.api.v1.runtime.RuntimeInfo;
import org.opennms.plugins.cloud.config.ConfigStore;
import org.opennms.plugins.cloud.config.ConfigurationManager;
import org.opennms.plugins.cloud.grpc.GrpcConnectionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Housekeeper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Housekeeper.class);
    private final ScheduledExecutorService executor;
    private final int intervalInSecondsForToken;
    private final int intervalInSecondsForCert;
    private final int intervalForSyncInSeconds;
    private final ConfigurationManager configurationManager;
    private final ConfigStore config;
    private final RuntimeInfo runtimeInfo;
    private GrpcConnectionConfig currentConfig;

    public Housekeeper(ConfigurationManager configurationManager, ConfigStore config, RuntimeInfo runtimeInfo, int intervalInSecondsForToken, int intervalInSecondsForCert, int intervalForSyncInSeconds) {
        this.configurationManager = configurationManager;
        this.config = Objects.requireNonNull(config);
        this.runtimeInfo = Objects.requireNonNull(runtimeInfo);
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.intervalInSecondsForToken = intervalInSecondsForToken;
        this.intervalInSecondsForCert = intervalInSecondsForCert;
        this.intervalForSyncInSeconds = intervalForSyncInSeconds;
    }

    public Housekeeper(ConfigurationManager configurationManager, ConfigStore config, RuntimeInfo runtimeInfo) {
        this(configurationManager, config, runtimeInfo, 3600, 72000, 300);
    }

    public void init() {
        if (Container.OPENNMS.equals((Object)this.runtimeInfo.getContainer())) {
            this.initForOpenNms();
        } else if (Container.SENTINEL.equals((Object)this.runtimeInfo.getContainer())) {
            this.initForSentinel();
        } else {
            log.error("It looks like we are running in a non supported environment, supported=OPENNMS, SENTINEL but it is {}", (Object)this.runtimeInfo.getContainer());
        }
    }

    private void initForOpenNms() {
        this.executor.scheduleAtFixedRate(() -> this.wrap(this::renewToken), 1L, this.intervalInSecondsForToken, TimeUnit.SECONDS);
        this.executor.scheduleAtFixedRate(() -> this.wrap(this::renewCerts), 1L, this.intervalInSecondsForCert, TimeUnit.SECONDS);
    }

    private void initForSentinel() {
        this.executor.scheduleAtFixedRate(() -> this.wrap(this::syncConfig), 1L, this.intervalForSyncInSeconds, TimeUnit.SECONDS);
    }

    public void destroy() {
        this.executor.shutdown();
    }

    public void renewToken() {
        Instant expirationDate = this.configurationManager.getTokenExpiration();
        if (expirationDate.minusSeconds(86400L).isBefore(Instant.now()) && this.isInitialized()) {
            log.info("Triggering renewal of configuration, token will expire soon.");
            this.configurationManager.configure();
        }
    }

    public void renewCerts() throws CertificateException {
        Instant expirationDate = this.configurationManager.getCertExpiration();
        if (expirationDate.minus(7L, ChronoUnit.DAYS).isBefore(Instant.now()) && this.isInitialized()) {
            log.info("Triggering renewal of certificates, will expire soon.");
            this.configurationManager.renewCerts();
            this.configurationManager.configure();
        }
    }

    private boolean isInitialized() {
        return ConfigurationManager.ConfigStatus.AUTHENTCATED.name().equals(this.config.getOrNull(ConfigStore.Key.configstatus)) || ConfigurationManager.ConfigStatus.CONFIGURED.name().equals(this.config.getOrNull(ConfigStore.Key.configstatus));
    }

    public void syncConfig() {
        GrpcConnectionConfig newConfig = this.createConfig();
        if (!Objects.equals(this.currentConfig, newConfig)) {
            this.configurationManager.configure();
            this.currentConfig = this.createConfig();
        }
    }

    private GrpcConnectionConfig createConfig() {
        return GrpcConnectionConfig.builder().privateKey(this.config.getOrNull(ConfigStore.Key.privatekey)).publicKey(this.config.getOrNull(ConfigStore.Key.publickey)).host(this.config.getOrNull(ConfigStore.Key.grpchost)).port(this.config.get(ConfigStore.Key.grpcport).map(Integer::valueOf).orElse(0)).build();
    }

    private void wrap(RunnableWithException r) {
        try {
            r.run();
        }
        catch (Exception e) {
            log.error("Job failed.", (Throwable)e);
        }
    }

    private static interface RunnableWithException {
        public void run() throws Exception;
    }
}

