/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.config;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.json.JSONObject;
import org.opennms.integration.api.v1.distributed.KeyValueStore;
import org.opennms.plugins.cloud.config.ConfigStore;

public class KvConfigStore
implements ConfigStore {
    final KeyValueStore<String> store;

    public KvConfigStore(KeyValueStore<String> keyValueStore) {
        this.store = Objects.requireNonNull(keyValueStore);
    }

    @Override
    public String getOrNull(ConfigStore.Key key) {
        return this.get(key).orElse(null);
    }

    @Override
    public Optional<String> get(ConfigStore.Key type) {
        return this.store.get(type.name(), "plugin.cloud").map(this::fromJson);
    }

    @Override
    public void putProperty(ConfigStore.Key key, String value) {
        this.store.put(key.name(), (Object)this.toJson(value), "plugin.cloud");
    }

    @Override
    public void putProperties(Map<ConfigStore.Key, String> properties) {
        Objects.requireNonNull(properties);
        properties.forEach(this::putProperty);
    }

    public String toJson(String value) {
        JSONObject json = new JSONObject();
        json.put("payload", (Object)value);
        return json.toString();
    }

    public String fromJson(String valueJson) {
        return new JSONObject(valueJson).getString("payload");
    }
}

