/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.config;

import lombok.Generated;
import org.opennms.integration.api.v1.runtime.Container;
import org.opennms.integration.api.v1.runtime.RuntimeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrerequisiteChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrerequisiteChecker.class);

    private PrerequisiteChecker() {
    }

    public static void checkAndLogSystemId(String systemId) {
        if (PrerequisiteChecker.isSystemIdOk(systemId)) {
            log.info("System id is set to {}", (Object)systemId);
        } else {
            log.warn("System id is not set up. It is advisable to set it up, see here: https://github.com/OpenNMS/opennms-cloud-plugin#system-id");
        }
    }

    static boolean isSystemIdOk(String systemId) {
        return systemId != null && systemId.length() >= 36 && !systemId.matches("[0-]*");
    }

    public static void checkAndLogContainer(RuntimeInfo info) {
        Container container = info.getContainer();
        if (container == Container.SENTINEL || container == Container.OPENNMS) {
            log.info("We are running in {}", (Object)container);
        } else {
            log.warn("We are running in an unknown container, expect undetermined results! Container = {}", (Object)container);
        }
    }
}

