/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.config;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opennms.integration.api.v1.scv.Credentials;
import org.opennms.integration.api.v1.scv.SecureCredentialsVault;
import org.opennms.integration.api.v1.scv.immutables.ImmutableCredentials;
import org.opennms.plugins.cloud.config.ConfigStore;

public class ScvConfigStore
implements ConfigStore {
    private final SecureCredentialsVault scv;

    public ScvConfigStore(SecureCredentialsVault scv) {
        this.scv = Objects.requireNonNull(scv);
    }

    private Optional<Credentials> getCredentials() {
        return Optional.ofNullable(this.scv.getCredentials("plugin.cloud"));
    }

    @Override
    public String getOrNull(ConfigStore.Key type) {
        return this.get(type).orElse(null);
    }

    @Override
    public Optional<String> get(ConfigStore.Key type) {
        return this.getCredentials().map(c -> c.getAttribute(type.name()));
    }

    @Override
    public void putProperty(ConfigStore.Key key, String value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.putProperties(Collections.singletonMap(key, value));
    }

    @Override
    public void putProperties(Map<ConfigStore.Key, String> properties) {
        Objects.requireNonNull(properties);
        HashMap propertiesToSave = new HashMap();
        this.getCredentials().map(Credentials::getAttributes).map(Map::entrySet).stream().flatMap(Collection::stream).forEach(e -> propertiesToSave.put((String)e.getKey(), (String)e.getValue()));
        properties.forEach((key, value) -> propertiesToSave.put(key.name(), value));
        ImmutableCredentials newCredentials = new ImmutableCredentials("", "", propertiesToSave);
        this.scv.setCredentials("plugin.cloud", (Credentials)newCredentials);
    }
}

