/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.grpc;

import java.util.Objects;
import lombok.Generated;

public class GrpcConnectionConfig {
    private final String host;
    private final int port;
    private final String tokenKey;
    private final String tokenValue;
    private final Security security;
    private final String publicKey;
    private final String privateKey;
    private final String clientTrustStore;

    public GrpcConnectionConfig(String host, int port, Security security, String clientTrustStore) {
        this(host, port, null, null, security, null, null, clientTrustStore);
    }

    private GrpcConnectionConfig(String host, int port, String tokenKey, String tokenValue, Security security, String publicKey, String privateKey, String clientTrustStore) {
        this.host = Objects.requireNonNull(host);
        this.port = this.requirePositiveNumber(port);
        this.tokenKey = tokenKey;
        this.tokenValue = tokenValue;
        this.security = security;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.clientTrustStore = clientTrustStore;
    }

    private int requirePositiveNumber(int value) {
        if (value < 0) {
            throw new IllegalArgumentException(String.format("A positive number is required but was %s", value));
        }
        return value;
    }

    @Generated
    public static GrpcConnectionConfigBuilder builder() {
        return new GrpcConnectionConfigBuilder();
    }

    @Generated
    public GrpcConnectionConfigBuilder toBuilder() {
        return new GrpcConnectionConfigBuilder().host(this.host).port(this.port).tokenKey(this.tokenKey).tokenValue(this.tokenValue).security(this.security).publicKey(this.publicKey).privateKey(this.privateKey).clientTrustStore(this.clientTrustStore);
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public String getTokenKey() {
        return this.tokenKey;
    }

    @Generated
    public String getTokenValue() {
        return this.tokenValue;
    }

    @Generated
    public Security getSecurity() {
        return this.security;
    }

    @Generated
    public String getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public String getPrivateKey() {
        return this.privateKey;
    }

    @Generated
    public String getClientTrustStore() {
        return this.clientTrustStore;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GrpcConnectionConfig)) {
            return false;
        }
        GrpcConnectionConfig other = (GrpcConnectionConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$tokenKey = this.getTokenKey();
        String other$tokenKey = other.getTokenKey();
        if (this$tokenKey == null ? other$tokenKey != null : !this$tokenKey.equals(other$tokenKey)) {
            return false;
        }
        String this$tokenValue = this.getTokenValue();
        String other$tokenValue = other.getTokenValue();
        if (this$tokenValue == null ? other$tokenValue != null : !this$tokenValue.equals(other$tokenValue)) {
            return false;
        }
        Security this$security = this.getSecurity();
        Security other$security = other.getSecurity();
        if (this$security == null ? other$security != null : !((Object)((Object)this$security)).equals((Object)other$security)) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        String this$clientTrustStore = this.getClientTrustStore();
        String other$clientTrustStore = other.getClientTrustStore();
        return !(this$clientTrustStore == null ? other$clientTrustStore != null : !this$clientTrustStore.equals(other$clientTrustStore));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GrpcConnectionConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $tokenKey = this.getTokenKey();
        result = result * 59 + ($tokenKey == null ? 43 : $tokenKey.hashCode());
        String $tokenValue = this.getTokenValue();
        result = result * 59 + ($tokenValue == null ? 43 : $tokenValue.hashCode());
        Security $security = this.getSecurity();
        result = result * 59 + ($security == null ? 43 : ((Object)((Object)$security)).hashCode());
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        String $clientTrustStore = this.getClientTrustStore();
        result = result * 59 + ($clientTrustStore == null ? 43 : $clientTrustStore.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GrpcConnectionConfig(host=" + this.getHost() + ", port=" + this.getPort() + ", tokenKey=" + this.getTokenKey() + ", tokenValue=" + this.getTokenValue() + ", security=" + this.getSecurity() + ", publicKey=" + this.getPublicKey() + ", privateKey=" + this.getPrivateKey() + ", clientTrustStore=" + this.getClientTrustStore() + ")";
    }

    public static class GrpcConnectionConfigBuilder {
        @Generated
        private int port;
        @Generated
        private String tokenValue;
        @Generated
        private String publicKey;
        @Generated
        private String privateKey;
        @Generated
        private String clientTrustStore;
        private String host = "localhost";
        private String tokenKey = "token";
        private Security security = Security.TLS;

        @Generated
        GrpcConnectionConfigBuilder() {
        }

        @Generated
        public GrpcConnectionConfigBuilder host(String host) {
            this.host = host;
            return this;
        }

        @Generated
        public GrpcConnectionConfigBuilder port(int port) {
            this.port = port;
            return this;
        }

        @Generated
        public GrpcConnectionConfigBuilder tokenKey(String tokenKey) {
            this.tokenKey = tokenKey;
            return this;
        }

        @Generated
        public GrpcConnectionConfigBuilder tokenValue(String tokenValue) {
            this.tokenValue = tokenValue;
            return this;
        }

        @Generated
        public GrpcConnectionConfigBuilder security(Security security) {
            this.security = security;
            return this;
        }

        @Generated
        public GrpcConnectionConfigBuilder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Generated
        public GrpcConnectionConfigBuilder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        @Generated
        public GrpcConnectionConfigBuilder clientTrustStore(String clientTrustStore) {
            this.clientTrustStore = clientTrustStore;
            return this;
        }

        @Generated
        public GrpcConnectionConfig build() {
            return new GrpcConnectionConfig(this.host, this.port, this.tokenKey, this.tokenValue, this.security, this.publicKey, this.privateKey, this.clientTrustStore);
        }

        @Generated
        public String toString() {
            return "GrpcConnectionConfig.GrpcConnectionConfigBuilder(host=" + this.host + ", port=" + this.port + ", tokenKey=" + this.tokenKey + ", tokenValue=" + this.tokenValue + ", security=" + this.security + ", publicKey=" + this.publicKey + ", privateKey=" + this.privateKey + ", clientTrustStore=" + this.clientTrustStore + ")";
        }
    }

    public static enum Security {
        TLS,
        MTLS;

    }
}

