/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.config;

import java.security.cert.CertificateException;
import java.time.Duration;
import java.time.Instant;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opennms.integration.api.v1.runtime.Container;
import org.opennms.integration.api.v1.runtime.RuntimeInfo;
import org.opennms.plugins.cloud.config.ConfigStore;
import org.opennms.plugins.cloud.config.ConfigurationManager;
import org.opennms.plugins.cloud.config.Housekeeper;

public class HousekeeperTest {
    private Housekeeper hk;
    private ConfigurationManager cm;
    private ConfigStore config;
    private RuntimeInfo runtimeInfo;

    @Before
    public void setUp() {
        this.config = (ConfigStore)Mockito.mock(ConfigStore.class);
        this.runtimeInfo = (RuntimeInfo)Mockito.mock(RuntimeInfo.class);
        this.cm = (ConfigurationManager)Mockito.mock(ConfigurationManager.class);
        Mockito.when((Object)this.config.getOrNull(ConfigStore.Key.configstatus)).thenReturn((Object)ConfigurationManager.ConfigStatus.CONFIGURED.name());
    }

    @Test
    public void shouldRenewConfigForExpiredTokenOpenNms() {
        Mockito.when((Object)this.runtimeInfo.getContainer()).thenReturn((Object)Container.OPENNMS);
        this.hk = new Housekeeper(this.cm, this.config, this.runtimeInfo, 1, 1, 1);
        ((ConfigurationManager)Mockito.doReturn((Object)Instant.now().plusSeconds(3600L)).doReturn((Object)Instant.now()).when((Object)this.cm)).getTokenExpiration();
        ((ConfigurationManager)Mockito.doReturn((Object)Instant.now().plusSeconds(3600L)).when((Object)this.cm)).getCertExpiration();
        this.hk.init();
        ((ConfigurationManager)Mockito.verify((Object)this.cm, (VerificationMode)Mockito.times((int)0))).configure();
        Awaitility.await().during(Duration.ofMillis(800L)).atMost(Duration.ofMillis(5000L)).until(() -> Mockito.mockingDetails((Object)this.cm).getInvocations().stream().anyMatch(i -> "configure".equals(i.getMethod().getName())));
        ((ConfigurationManager)Mockito.verify((Object)this.cm, (VerificationMode)Mockito.times((int)2))).configure();
    }

    @Test
    public void shouldRenewExpiredCertsOpenNms() throws CertificateException {
        Mockito.when((Object)this.runtimeInfo.getContainer()).thenReturn((Object)Container.OPENNMS);
        this.hk = new Housekeeper(this.cm, this.config, this.runtimeInfo, 1, 1, 1);
        ((ConfigurationManager)Mockito.doReturn((Object)Instant.now().plusSeconds(3600L)).doReturn((Object)Instant.now()).when((Object)this.cm)).getCertExpiration();
        ((ConfigurationManager)Mockito.doReturn((Object)Instant.now().plusSeconds(3600L)).when((Object)this.cm)).getTokenExpiration();
        this.hk.init();
        ((ConfigurationManager)Mockito.verify((Object)this.cm, (VerificationMode)Mockito.times((int)0))).renewCerts();
        ((ConfigurationManager)Mockito.verify((Object)this.cm, (VerificationMode)Mockito.times((int)0))).configure();
        Awaitility.await().during(Duration.ofMillis(800L)).atMost(Duration.ofMillis(5000L)).until(() -> Mockito.mockingDetails((Object)this.cm).getInvocations().stream().anyMatch(i -> "renewCerts".equals(i.getMethod().getName())));
        ((ConfigurationManager)Mockito.verify((Object)this.cm, (VerificationMode)Mockito.times((int)1))).renewCerts();
        ((ConfigurationManager)Mockito.verify((Object)this.cm, (VerificationMode)Mockito.times((int)2))).configure();
    }

    @Test
    public void shouldNotCrashOnExceptionOpenNms() throws CertificateException {
        Mockito.when((Object)this.runtimeInfo.getContainer()).thenReturn((Object)Container.OPENNMS);
        this.hk = new Housekeeper(this.cm, this.config, this.runtimeInfo, 1, 1000, 1);
        ((ConfigurationManager)Mockito.doReturn((Object)Instant.now()).when((Object)this.cm)).getTokenExpiration();
        ((ConfigurationManager)Mockito.doReturn((Object)Instant.now().plusSeconds(3600L)).when((Object)this.cm)).getCertExpiration();
        ((ConfigurationManager)Mockito.doThrow((Throwable[])new Throwable[]{new NullPointerException("oh oh")}).when((Object)this.cm)).configure();
        this.hk.init();
        ((ConfigurationManager)Mockito.verify((Object)this.cm, (VerificationMode)Mockito.times((int)0))).configure();
        Awaitility.await().during(Duration.ofMillis(800L)).atMost(Duration.ofMillis(5000L)).until(() -> Mockito.mockingDetails((Object)this.cm).getInvocations().stream().anyMatch(i -> "configure".equals(i.getMethod().getName())));
        ((ConfigurationManager)Mockito.verify((Object)this.cm, (VerificationMode)Mockito.times((int)2))).configure();
        Mockito.clearInvocations((Object[])new ConfigurationManager[]{this.cm});
        Awaitility.await().during(Duration.ofMillis(800L)).atMost(Duration.ofMillis(5000L)).until(() -> Mockito.mockingDetails((Object)this.cm).getInvocations().stream().anyMatch(i -> "configure".equals(i.getMethod().getName())));
        ((ConfigurationManager)Mockito.verify((Object)this.cm, (VerificationMode)Mockito.times((int)1))).configure();
    }

    @Test
    public void shouldReconfigureIfConfigChanged_Sentinel() {
        Mockito.when((Object)this.runtimeInfo.getContainer()).thenReturn((Object)Container.SENTINEL);
        this.hk = new Housekeeper(this.cm, this.config, this.runtimeInfo, 1, 1, 1);
        this.hk.init();
        Awaitility.await().during(Duration.ofMillis(2000L)).atMost(Duration.ofMillis(3000L)).until(() -> Mockito.mockingDetails((Object)this.cm).getInvocations().stream().noneMatch(i -> "configure".equals(i.getMethod().getName())));
        ((ConfigurationManager)Mockito.verify((Object)this.cm, (VerificationMode)Mockito.never())).configure();
        ((ConfigStore)Mockito.doReturn((Object)"someNewHost").when((Object)this.config)).getOrNull(ConfigStore.Key.grpchost);
        Awaitility.await().during(Duration.ofMillis(2000L)).atMost(Duration.ofMillis(3000L)).until(() -> Mockito.mockingDetails((Object)this.cm).getInvocations().stream().anyMatch(i -> "configure".equals(i.getMethod().getName())));
        ((ConfigurationManager)Mockito.verify((Object)this.cm, (VerificationMode)Mockito.times((int)1))).configure();
        Mockito.clearInvocations((Object[])new ConfigurationManager[]{this.cm});
        Awaitility.await().during(Duration.ofMillis(2000L)).atMost(Duration.ofMillis(3000L)).until(() -> Mockito.mockingDetails((Object)this.cm).getInvocations().stream().noneMatch(i -> "configure".equals(i.getMethod().getName())));
        ((ConfigurationManager)Mockito.verify((Object)this.cm, (VerificationMode)Mockito.never())).configure();
        Mockito.clearInvocations((Object[])new ConfigurationManager[]{this.cm});
        Awaitility.await().during(Duration.ofMillis(2000L)).atMost(Duration.ofMillis(3000L)).until(() -> Mockito.mockingDetails((Object)this.cm).getInvocations().stream().noneMatch(i -> "configure".equals(i.getMethod().getName())));
        ((ConfigurationManager)Mockito.verify((Object)this.cm, (VerificationMode)Mockito.never())).configure();
    }

    @Test
    public void shouldTriggerNothingIfNotInitialized_OpenNms() throws CertificateException {
        Mockito.when((Object)this.cm.getStatus()).thenReturn((Object)ConfigurationManager.ConfigStatus.NOT_ATTEMPTED);
        this.shouldTriggerNothing(Container.OPENNMS);
    }

    @Test
    public void shouldTriggerNothingIfNotInitialized_Sentinel() throws CertificateException {
        this.shouldTriggerNothing(Container.SENTINEL);
    }

    @Test
    public void shouldTriggerNothingIfUnsupportedContainer() throws CertificateException {
        Mockito.when((Object)this.cm.getStatus()).thenReturn((Object)ConfigurationManager.ConfigStatus.CONFIGURED);
        this.shouldTriggerNothing(Container.MINION);
        this.shouldTriggerNothing(Container.OTHER);
    }

    private void shouldTriggerNothing(Container container) throws CertificateException {
        Mockito.when((Object)this.runtimeInfo.getContainer()).thenReturn((Object)container);
        this.hk = new Housekeeper(this.cm, this.config, this.runtimeInfo, 1, 1, 1);
        this.hk.init();
        Awaitility.await().during(Duration.ofMillis(2000L)).atMost(Duration.ofMillis(3000L)).until(() -> Mockito.mockingDetails((Object)this.cm).getInvocations().stream().noneMatch(i -> "configure".equals(i.getMethod().getName())));
        ((ConfigurationManager)Mockito.verify((Object)this.cm, (VerificationMode)Mockito.never())).configure();
        ((ConfigurationManager)Mockito.verify((Object)this.cm, (VerificationMode)Mockito.never())).renewCerts();
    }

    @After
    public void tearDown() {
        this.hk.destroy();
    }
}

